/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.openstack.keystone.v2_0;

import com.google.auto.service.AutoService;
import com.google.common.collect.ImmutableSet;
import java.net.URI;
import java.util.Properties;
import java.util.Set;
import org.jclouds.apis.ApiMetadata;
import org.jclouds.openstack.keystone.v2_0.KeystoneApi;
import org.jclouds.openstack.keystone.v2_0.config.AuthenticationApiModule;
import org.jclouds.openstack.keystone.v2_0.config.KeystoneAuthenticationModule;
import org.jclouds.openstack.keystone.v2_0.config.KeystoneHttpApiModule;
import org.jclouds.openstack.keystone.v2_0.config.KeystoneParserModule;
import org.jclouds.rest.internal.BaseHttpApiMetadata;

@AutoService(value=ApiMetadata.class)
public class KeystoneApiMetadata
extends BaseHttpApiMetadata<KeystoneApi> {
    public Builder<?> toBuilder() {
        return (Builder)new ConcreteBuilder().fromApiMetadata((ApiMetadata)this);
    }

    public KeystoneApiMetadata() {
        this(new ConcreteBuilder());
    }

    protected KeystoneApiMetadata(Builder<?> builder) {
        super(builder);
    }

    public static Properties defaultProperties() {
        Properties properties = BaseHttpApiMetadata.defaultProperties();
        properties.setProperty("jclouds.keystone.credential-type", "passwordCredentials");
        properties.setProperty("jclouds.keystone.service-type", "identity");
        return properties;
    }

    private static class ConcreteBuilder
    extends Builder<ConcreteBuilder> {
        private ConcreteBuilder() {
        }

        protected ConcreteBuilder self() {
            return this;
        }
    }

    public static abstract class Builder<T extends Builder<T>>
    extends BaseHttpApiMetadata.Builder<KeystoneApi, T> {
        protected Builder() {
            ((Builder)((Builder)((Builder)((Builder)((Builder)((Builder)((Builder)((Builder)((Builder)this.id("openstack-keystone")).name("OpenStack Keystone Essex+ API")).identityName("${tenantName}:${userName} or ${userName}, if your keystone supports a default tenant")).credentialName("${password}")).endpointName("Keystone base url ending in /v${jclouds.api-version}/")).documentation(URI.create("http://api.openstack.org/"))).version("2.0")).defaultEndpoint("http://localhost:5000/v${jclouds.api-version}/")).defaultProperties(KeystoneApiMetadata.defaultProperties())).defaultModules((Set)ImmutableSet.builder().add(AuthenticationApiModule.class).add(KeystoneAuthenticationModule.class).add(KeystoneHttpApiModule.KeystoneAdminURLModule.class).add(KeystoneParserModule.class).add(KeystoneHttpApiModule.class).build());
        }

        public KeystoneApiMetadata build() {
            return new KeystoneApiMetadata(this);
        }
    }
}

