/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.openstack.keystone.v2_0.functions.internal;

import com.google.common.base.Function;
import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import com.google.inject.Inject;
import com.google.inject.name.Named;
import javax.annotation.PostConstruct;
import javax.annotation.Resource;
import org.jclouds.domain.Credentials;
import org.jclouds.logging.Logger;
import org.jclouds.openstack.keystone.v2_0.domain.Access;

public abstract class BaseAuthenticator<C>
implements Function<Credentials, Access> {
    @Resource
    protected Logger logger = Logger.NULL;
    @Inject(optional=true)
    @Named(value="jclouds.keystone.tenant-name")
    protected String defaultTenantName;
    @Inject(optional=true)
    @Named(value="jclouds.keystone.tenant-id")
    protected String defaultTenantId;
    @Inject(optional=true)
    @Named(value="jclouds.keystone.requires-tenant")
    protected boolean requiresTenant;

    @PostConstruct
    public void checkPropertiesAreCompatible() {
        Preconditions.checkState((this.defaultTenantName == null || this.defaultTenantId == null ? 1 : 0) != 0, (String)"you cannot specify both %s and %s", (Object[])new Object[]{"jclouds.keystone.tenant-name", "jclouds.keystone.tenant-id"});
    }

    public Access apply(Credentials input) {
        Access access;
        Optional tenantName = Optional.fromNullable((Object)this.defaultTenantName);
        Optional tenantId = Optional.fromNullable((Object)this.defaultTenantId);
        String usernameOrAccessKey = input.identity;
        if (!tenantName.isPresent() && input.identity.indexOf(58) != -1) {
            tenantName = Optional.of((Object)input.identity.substring(0, input.identity.lastIndexOf(58)));
            usernameOrAccessKey = input.identity.substring(input.identity.lastIndexOf(58) + 1);
        }
        String passwordOrSecretKey = input.credential;
        C creds = this.createCredentials(usernameOrAccessKey, passwordOrSecretKey);
        if (tenantId.isPresent()) {
            access = this.authenticateWithTenantId((Optional<String>)tenantId, creds);
        } else if (tenantName.isPresent()) {
            access = this.authenticateWithTenantName((Optional<String>)tenantName, creds);
        } else if (!this.requiresTenant) {
            access = this.authenticateWithTenantName((Optional<String>)tenantName, creds);
        } else {
            throw new IllegalArgumentException(String.format("current configuration is set to [%s]. Unless you set [%s] or [%s], you must prefix your identity with 'tenantName:'", "jclouds.keystone.requires-tenant", "jclouds.keystone.tenant-name", "jclouds.keystone.tenant-id"));
        }
        return access;
    }

    public abstract C createCredentials(String var1, String var2);

    protected abstract Access authenticateWithTenantId(Optional<String> var1, C var2);

    protected abstract Access authenticateWithTenantName(Optional<String> var1, C var2);
}

