/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.vcloud.binders;

import com.google.common.base.Preconditions;
import com.google.common.base.Throwables;
import com.google.inject.Inject;
import com.jamesmurty.utils.XMLBuilder;
import java.util.Properties;
import javax.annotation.Resource;
import javax.inject.Named;
import javax.inject.Singleton;
import org.jclouds.http.HttpRequest;
import org.jclouds.logging.Logger;
import org.jclouds.rest.binders.BindToStringPayload;
import org.jclouds.vcloud.domain.NetworkConnection;
import org.jclouds.vcloud.domain.NetworkConnectionSection;

@Singleton
public class BindNetworkConnectionSectionToXmlPayload
extends BindToStringPayload {
    @Resource
    protected Logger logger = Logger.NULL;
    protected final String ns;
    protected final String schema;

    @Inject
    public BindNetworkConnectionSectionToXmlPayload(BindToStringPayload stringBinder, @Named(value="jclouds.vcloud.xml.ns") String ns, @Named(value="jclouds.vcloud.xml.schema") String schema) {
        this.ns = ns;
        this.schema = schema;
    }

    public <R extends HttpRequest> R bindToRequest(R request, Object payload) {
        Preconditions.checkArgument((boolean)(Preconditions.checkNotNull((Object)payload, (Object)"NetworkConnectionSection") instanceof NetworkConnectionSection), (Object)"this binder is only valid for NetworkConnectionSection!");
        NetworkConnectionSection net = (NetworkConnectionSection)NetworkConnectionSection.class.cast(payload);
        try {
            XMLBuilder networkConnectionSection = XMLBuilder.create((String)"NetworkConnectionSection").a("xmlns", this.ns).a("xmlns:ovf", "http://schemas.dmtf.org/ovf/envelope/1").a("type", net.getType()).a("href", net.getHref().toASCIIString()).a("ovf:required", "false");
            networkConnectionSection.e("ovf:Info").t(net.getInfo());
            if (net.getPrimaryNetworkConnectionIndex() != null) {
                networkConnectionSection.e("PrimaryNetworkConnectionIndex").t(net.getPrimaryNetworkConnectionIndex().toString());
            }
            for (NetworkConnection networkConnection : net.getConnections()) {
                XMLBuilder networkConnectionSectionChild = networkConnectionSection.e("NetworkConnection").a("network", networkConnection.getNetwork());
                networkConnectionSectionChild.e("NetworkConnectionIndex").t(networkConnection.getNetworkConnectionIndex() + "");
                if (networkConnection.getExternalIpAddress() != null) {
                    networkConnectionSectionChild.e("ExternalIpAddress").t(networkConnection.getExternalIpAddress());
                }
                if (networkConnection.getIpAddress() != null) {
                    networkConnectionSectionChild.e("IpAddress").t(networkConnection.getIpAddress());
                }
                networkConnectionSectionChild.e("IsConnected").t(networkConnection.isConnected() + "");
                if (networkConnection.getMACAddress() != null) {
                    networkConnectionSectionChild.e("MACAddress").t(networkConnection.getMACAddress());
                }
                if (networkConnection.getIpAddressAllocationMode() == null) continue;
                networkConnectionSectionChild.e("IpAddressAllocationMode").t(networkConnection.getIpAddressAllocationMode().toString());
            }
            if (net.getEdit() != null) {
                networkConnectionSection.e("Link").a("rel", "edit").a("type", net.getType()).a("href", net.getHref().toASCIIString());
            }
            Properties outputProperties = new Properties();
            outputProperties.put("omit-xml-declaration", "yes");
            request = super.bindToRequest(request, (Object)networkConnectionSection.asString(outputProperties));
            request.getPayload().getContentMetadata().setContentType(net.getType());
        }
        catch (Exception e) {
            Throwables.propagate((Throwable)e);
        }
        return request;
    }
}

