/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.vcloud.features;

import java.net.URI;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import org.jclouds.Fallbacks;
import org.jclouds.javax.annotation.Nullable;
import org.jclouds.ovf.Envelope;
import org.jclouds.ovf.xml.EnvelopeHandler;
import org.jclouds.predicates.validators.DnsNameValidator;
import org.jclouds.rest.annotations.EndpointParam;
import org.jclouds.rest.annotations.Fallback;
import org.jclouds.rest.annotations.MapBinder;
import org.jclouds.rest.annotations.ParamValidators;
import org.jclouds.rest.annotations.PayloadParam;
import org.jclouds.rest.annotations.PayloadParams;
import org.jclouds.rest.annotations.RequestFilters;
import org.jclouds.rest.annotations.XMLResponseParser;
import org.jclouds.vcloud.binders.BindCaptureVAppParamsToXmlPayload;
import org.jclouds.vcloud.binders.BindCloneVAppTemplateParamsToXmlPayload;
import org.jclouds.vcloud.binders.BindInstantiateVAppTemplateParamsToXmlPayload;
import org.jclouds.vcloud.binders.OrgNameCatalogNameVAppTemplateNameToEndpoint;
import org.jclouds.vcloud.domain.Task;
import org.jclouds.vcloud.domain.VApp;
import org.jclouds.vcloud.domain.VAppTemplate;
import org.jclouds.vcloud.filters.AddVCloudAuthorizationAndCookieToRequest;
import org.jclouds.vcloud.options.CaptureVAppOptions;
import org.jclouds.vcloud.options.CloneVAppTemplateOptions;
import org.jclouds.vcloud.options.InstantiateVAppTemplateOptions;
import org.jclouds.vcloud.xml.TaskHandler;
import org.jclouds.vcloud.xml.VAppHandler;
import org.jclouds.vcloud.xml.VAppTemplateHandler;

@RequestFilters(value={AddVCloudAuthorizationAndCookieToRequest.class})
public interface VAppTemplateApi {
    @GET
    @Consumes(value={"application/vnd.vmware.vcloud.vAppTemplate+xml"})
    @XMLResponseParser(value=VAppTemplateHandler.class)
    @Fallback(value=Fallbacks.NullOnNotFoundOr404.class)
    @MapBinder(value=OrgNameCatalogNameVAppTemplateNameToEndpoint.class)
    public VAppTemplate findVAppTemplateInOrgCatalogNamed(@Nullable @PayloadParam(value="orgName") String var1, @Nullable @PayloadParam(value="catalogName") String var2, @PayloadParam(value="itemName") String var3);

    @POST
    @Path(value="/action/instantiateVAppTemplate")
    @Produces(value={"application/vnd.vmware.vcloud.instantiateVAppTemplateParams+xml"})
    @Consumes(value={"application/vnd.vmware.vcloud.vApp+xml"})
    @XMLResponseParser(value=VAppHandler.class)
    @MapBinder(value=BindInstantiateVAppTemplateParamsToXmlPayload.class)
    public VApp createVAppInVDCByInstantiatingTemplate(@PayloadParam(value="name") @ParamValidators(value={DnsNameValidator.class}) String var1, @EndpointParam URI var2, @PayloadParam(value="template") URI var3, InstantiateVAppTemplateOptions ... var4);

    @POST
    @Path(value="/action/cloneVAppTemplate")
    @Produces(value={"application/vnd.vmware.vcloud.cloneVAppTemplateParams+xml"})
    @Consumes(value={"application/vnd.vmware.vcloud.task+xml"})
    @XMLResponseParser(value=TaskHandler.class)
    @MapBinder(value=BindCloneVAppTemplateParamsToXmlPayload.class)
    public Task copyVAppTemplateToVDCAndName(@PayloadParam(value="Source") URI var1, @EndpointParam URI var2, @PayloadParam(value="name") @ParamValidators(value={DnsNameValidator.class}) String var3, CloneVAppTemplateOptions ... var4);

    @POST
    @Path(value="/action/cloneVAppTemplate")
    @Produces(value={"application/vnd.vmware.vcloud.cloneVAppTemplateParams+xml"})
    @Consumes(value={"application/vnd.vmware.vcloud.task+xml"})
    @XMLResponseParser(value=TaskHandler.class)
    @PayloadParams(keys={"IsSourceDelete"}, values={"true"})
    @MapBinder(value=BindCloneVAppTemplateParamsToXmlPayload.class)
    public Task moveVAppTemplateToVDCAndRename(@PayloadParam(value="Source") URI var1, @EndpointParam URI var2, @PayloadParam(value="name") @ParamValidators(value={DnsNameValidator.class}) String var3, CloneVAppTemplateOptions ... var4);

    @POST
    @Path(value="/action/captureVApp")
    @Produces(value={"application/vnd.vmware.vcloud.captureVAppParams+xml"})
    @Consumes(value={"application/vnd.vmware.vcloud.vAppTemplate+xml"})
    @XMLResponseParser(value=VAppTemplateHandler.class)
    @MapBinder(value=BindCaptureVAppParamsToXmlPayload.class)
    public VAppTemplate captureVAppAsTemplateInVDC(@PayloadParam(value="vApp") URI var1, @PayloadParam(value="templateName") @ParamValidators(value={DnsNameValidator.class}) String var2, @EndpointParam URI var3, CaptureVAppOptions ... var4);

    @GET
    @Consumes(value={"application/vnd.vmware.vcloud.vAppTemplate+xml"})
    @XMLResponseParser(value=VAppTemplateHandler.class)
    @Fallback(value=Fallbacks.NullOnNotFoundOr404.class)
    public VAppTemplate getVAppTemplate(@EndpointParam URI var1);

    @GET
    @Consumes(value={"text/xml"})
    @Path(value="/ovf")
    @XMLResponseParser(value=EnvelopeHandler.class)
    @Fallback(value=Fallbacks.NullOnNotFoundOr404.class)
    public Envelope getOvfEnvelopeForVAppTemplate(@EndpointParam URI var1);

    @DELETE
    @Consumes(value={"application/vnd.vmware.vcloud.task+xml"})
    @Fallback(value=Fallbacks.VoidOnNotFoundOr404.class)
    @XMLResponseParser(value=TaskHandler.class)
    public Task deleteVAppTemplate(@EndpointParam URI var1);
}

