/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.vcloud.functions;

import com.google.common.base.Function;
import com.google.common.base.Predicate;
import com.google.common.collect.FluentIterable;
import com.google.common.collect.Iterables;
import java.net.URI;
import javax.annotation.Resource;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.jclouds.domain.Location;
import org.jclouds.domain.LocationScope;
import org.jclouds.logging.Logger;
import org.jclouds.vcloud.VCloudApi;
import org.jclouds.vcloud.domain.Org;

@Singleton
public class OrgsForLocations
implements Function<Iterable<Location>, Iterable<Org>> {
    @Resource
    public Logger logger = Logger.NULL;
    private final VCloudApi aclient;

    @Inject
    OrgsForLocations(VCloudApi aclient) {
        this.aclient = aclient;
    }

    public Iterable<Org> apply(Iterable<Location> from) {
        FluentIterable uris = FluentIterable.from(from).filter((Predicate)new Predicate<Location>(){

            public boolean apply(Location input) {
                return input.getScope() == LocationScope.ZONE;
            }
        }).transform((Function)new Function<Location, URI>(){

            public URI apply(Location from) {
                return URI.create(from.getParent().getId());
            }
        });
        return Iterables.transform((Iterable)uris, (Function)new Function<URI, Org>(){

            public Org apply(URI from) {
                return OrgsForLocations.this.aclient.getOrgApi().getOrg(from);
            }
        });
    }
}

