/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.blobstore.functions;

import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import jakarta.inject.Singleton;
import org.jclouds.http.options.GetOptions;

@Singleton
public class BlobToHttpGetOptions
implements Function<org.jclouds.blobstore.options.GetOptions, GetOptions> {
    public GetOptions apply(org.jclouds.blobstore.options.GetOptions from) {
        Preconditions.checkNotNull((Object)from, (Object)"options");
        if (from == org.jclouds.blobstore.options.GetOptions.NONE) {
            return GetOptions.NONE;
        }
        GetOptions httpOptions = new GetOptions();
        if (from.getIfMatch() != null) {
            httpOptions.ifETagMatches(from.getIfMatch());
        }
        if (from.getIfModifiedSince() != null) {
            httpOptions.ifModifiedSince(from.getIfModifiedSince());
        }
        if (from.getIfNoneMatch() != null) {
            httpOptions.ifETagDoesntMatch(from.getIfNoneMatch());
        }
        if (from.getIfUnmodifiedSince() != null) {
            httpOptions.ifUnmodifiedSince(from.getIfUnmodifiedSince());
        }
        for (String range : from.getRanges()) {
            String[] firstLast = range.split("\\-", 2);
            if (!firstLast[0].isEmpty() && !firstLast[1].isEmpty()) {
                httpOptions.range(Long.parseLong(firstLast[0]), Long.parseLong(firstLast[1]));
                continue;
            }
            if (firstLast[0].isEmpty() && !firstLast[1].isEmpty()) {
                httpOptions.tail(Long.parseLong(firstLast[1]));
                continue;
            }
            httpOptions.startAt(Long.parseLong(firstLast[0]));
        }
        return httpOptions;
    }
}

