/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.azurecompute.arm.domain;

import org.jclouds.azurecompute.arm.domain.DnsSettings;
import org.jclouds.azurecompute.arm.domain.IdReference;
import org.jclouds.azurecompute.arm.domain.PublicIPAddressProperties;
import org.jclouds.javax.annotation.Nullable;

final class AutoValue_PublicIPAddressProperties
extends PublicIPAddressProperties {
    private final String provisioningState;
    private final String ipAddress;
    private final String publicIPAllocationMethod;
    private final Integer idleTimeoutInMinutes;
    private final IdReference ipConfiguration;
    private final DnsSettings dnsSettings;

    private AutoValue_PublicIPAddressProperties(@Nullable String provisioningState, @Nullable String ipAddress, String publicIPAllocationMethod, @Nullable Integer idleTimeoutInMinutes, @Nullable IdReference ipConfiguration, @Nullable DnsSettings dnsSettings) {
        this.provisioningState = provisioningState;
        this.ipAddress = ipAddress;
        this.publicIPAllocationMethod = publicIPAllocationMethod;
        this.idleTimeoutInMinutes = idleTimeoutInMinutes;
        this.ipConfiguration = ipConfiguration;
        this.dnsSettings = dnsSettings;
    }

    @Override
    @Nullable
    public String provisioningState() {
        return this.provisioningState;
    }

    @Override
    @Nullable
    public String ipAddress() {
        return this.ipAddress;
    }

    @Override
    public String publicIPAllocationMethod() {
        return this.publicIPAllocationMethod;
    }

    @Override
    @Nullable
    public Integer idleTimeoutInMinutes() {
        return this.idleTimeoutInMinutes;
    }

    @Override
    @Nullable
    public IdReference ipConfiguration() {
        return this.ipConfiguration;
    }

    @Override
    @Nullable
    public DnsSettings dnsSettings() {
        return this.dnsSettings;
    }

    public String toString() {
        return "PublicIPAddressProperties{provisioningState=" + this.provisioningState + ", " + "ipAddress=" + this.ipAddress + ", " + "publicIPAllocationMethod=" + this.publicIPAllocationMethod + ", " + "idleTimeoutInMinutes=" + this.idleTimeoutInMinutes + ", " + "ipConfiguration=" + this.ipConfiguration + ", " + "dnsSettings=" + this.dnsSettings + "}";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof PublicIPAddressProperties) {
            PublicIPAddressProperties that = (PublicIPAddressProperties)o;
            return (this.provisioningState == null ? that.provisioningState() == null : this.provisioningState.equals(that.provisioningState())) && (this.ipAddress == null ? that.ipAddress() == null : this.ipAddress.equals(that.ipAddress())) && this.publicIPAllocationMethod.equals(that.publicIPAllocationMethod()) && (this.idleTimeoutInMinutes == null ? that.idleTimeoutInMinutes() == null : this.idleTimeoutInMinutes.equals(that.idleTimeoutInMinutes())) && (this.ipConfiguration == null ? that.ipConfiguration() == null : this.ipConfiguration.equals(that.ipConfiguration())) && (this.dnsSettings == null ? that.dnsSettings() == null : this.dnsSettings.equals(that.dnsSettings()));
        }
        return false;
    }

    public int hashCode() {
        int h = 1;
        h *= 1000003;
        h ^= this.provisioningState == null ? 0 : this.provisioningState.hashCode();
        h *= 1000003;
        h ^= this.ipAddress == null ? 0 : this.ipAddress.hashCode();
        h *= 1000003;
        h ^= this.publicIPAllocationMethod.hashCode();
        h *= 1000003;
        h ^= this.idleTimeoutInMinutes == null ? 0 : this.idleTimeoutInMinutes.hashCode();
        h *= 1000003;
        h ^= this.ipConfiguration == null ? 0 : this.ipConfiguration.hashCode();
        h *= 1000003;
        return h ^= this.dnsSettings == null ? 0 : this.dnsSettings.hashCode();
    }

    @Override
    public PublicIPAddressProperties.Builder toBuilder() {
        return new Builder(this);
    }

    static final class Builder
    extends PublicIPAddressProperties.Builder {
        private String provisioningState;
        private String ipAddress;
        private String publicIPAllocationMethod;
        private Integer idleTimeoutInMinutes;
        private IdReference ipConfiguration;
        private DnsSettings dnsSettings;

        Builder() {
        }

        private Builder(PublicIPAddressProperties source) {
            this.provisioningState = source.provisioningState();
            this.ipAddress = source.ipAddress();
            this.publicIPAllocationMethod = source.publicIPAllocationMethod();
            this.idleTimeoutInMinutes = source.idleTimeoutInMinutes();
            this.ipConfiguration = source.ipConfiguration();
            this.dnsSettings = source.dnsSettings();
        }

        @Override
        public PublicIPAddressProperties.Builder provisioningState(@Nullable String provisioningState) {
            this.provisioningState = provisioningState;
            return this;
        }

        @Override
        public PublicIPAddressProperties.Builder ipAddress(@Nullable String ipAddress) {
            this.ipAddress = ipAddress;
            return this;
        }

        @Override
        public PublicIPAddressProperties.Builder publicIPAllocationMethod(String publicIPAllocationMethod) {
            if (publicIPAllocationMethod == null) {
                throw new NullPointerException("Null publicIPAllocationMethod");
            }
            this.publicIPAllocationMethod = publicIPAllocationMethod;
            return this;
        }

        @Override
        public PublicIPAddressProperties.Builder idleTimeoutInMinutes(@Nullable Integer idleTimeoutInMinutes) {
            this.idleTimeoutInMinutes = idleTimeoutInMinutes;
            return this;
        }

        @Override
        public PublicIPAddressProperties.Builder ipConfiguration(@Nullable IdReference ipConfiguration) {
            this.ipConfiguration = ipConfiguration;
            return this;
        }

        @Override
        public PublicIPAddressProperties.Builder dnsSettings(@Nullable DnsSettings dnsSettings) {
            this.dnsSettings = dnsSettings;
            return this;
        }

        @Override
        public PublicIPAddressProperties build() {
            String missing = "";
            if (this.publicIPAllocationMethod == null) {
                missing = missing + " publicIPAllocationMethod";
            }
            if (!missing.isEmpty()) {
                throw new IllegalStateException("Missing required properties:" + missing);
            }
            return new AutoValue_PublicIPAddressProperties(this.provisioningState, this.ipAddress, this.publicIPAllocationMethod, this.idleTimeoutInMinutes, this.ipConfiguration, this.dnsSettings);
        }
    }
}

