/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.azurecompute.arm.features;

import java.util.List;
import java.util.Map;
import javax.inject.Named;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import org.jclouds.Fallbacks;
import org.jclouds.azurecompute.arm.domain.VirtualNetwork;
import org.jclouds.azurecompute.arm.filters.ApiVersionFilter;
import org.jclouds.azurecompute.arm.functions.FalseOn204;
import org.jclouds.javax.annotation.Nullable;
import org.jclouds.oauth.v2.filters.OAuthFilter;
import org.jclouds.rest.annotations.Fallback;
import org.jclouds.rest.annotations.MapBinder;
import org.jclouds.rest.annotations.PayloadParam;
import org.jclouds.rest.annotations.RequestFilters;
import org.jclouds.rest.annotations.ResponseParser;
import org.jclouds.rest.annotations.SelectJson;
import org.jclouds.rest.binders.BindToJsonPayload;

@Path(value="/resourcegroups/{resourcegroup}/providers/Microsoft.Network/virtualNetworks")
@RequestFilters(value={OAuthFilter.class, ApiVersionFilter.class})
@Consumes(value={"application/json"})
public interface VirtualNetworkApi {
    @Named(value="virtualnetwork:list")
    @SelectJson(value={"value"})
    @GET
    @Fallback(value=Fallbacks.EmptyListOnNotFoundOr404.class)
    public List<VirtualNetwork> list();

    @Named(value="virtualnetwork:create_or_update")
    @Path(value="/{virtualnetworkname}")
    @MapBinder(value=BindToJsonPayload.class)
    @PUT
    public VirtualNetwork createOrUpdate(@PathParam(value="virtualnetworkname") String var1, @PayloadParam(value="location") String var2, @Nullable @PayloadParam(value="tags") Map<String, String> var3, @PayloadParam(value="properties") VirtualNetwork.VirtualNetworkProperties var4);

    @Named(value="virtualnetwork:get")
    @Path(value="/{virtualnetworkname}")
    @GET
    @Fallback(value=Fallbacks.NullOnNotFoundOr404.class)
    public VirtualNetwork get(@PathParam(value="virtualnetworkname") String var1);

    @Named(value="virtualnetwork:delete")
    @Path(value="/{virtualnetworkname}")
    @DELETE
    @ResponseParser(value=FalseOn204.class)
    public boolean delete(@PathParam(value="virtualnetworkname") String var1);
}

