/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.enterprisechef;

import java.util.Set;
import javax.inject.Named;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import org.jclouds.Fallbacks;
import org.jclouds.chef.ChefApi;
import org.jclouds.chef.filters.SignedHeaderAuth;
import org.jclouds.chef.functions.ParseKeySetFromJson;
import org.jclouds.enterprisechef.binders.BindGroupToUpdateRequestJsonPayload;
import org.jclouds.enterprisechef.binders.GroupName;
import org.jclouds.enterprisechef.domain.Group;
import org.jclouds.enterprisechef.domain.User;
import org.jclouds.rest.annotations.BinderParam;
import org.jclouds.rest.annotations.Fallback;
import org.jclouds.rest.annotations.Headers;
import org.jclouds.rest.annotations.ParamParser;
import org.jclouds.rest.annotations.RequestFilters;
import org.jclouds.rest.annotations.ResponseParser;
import org.jclouds.rest.annotations.WrapWith;

@RequestFilters(value={SignedHeaderAuth.class})
@Consumes(value={"application/json"})
@Headers(keys={"X-Chef-Version"}, values={"{jclouds.api-version}"})
public interface EnterpriseChefApi
extends ChefApi {
    @Named(value="user:get")
    @GET
    @Path(value="/users/{name}")
    @Fallback(value=Fallbacks.NullOnNotFoundOr404.class)
    public User getUser(@PathParam(value="name") String var1);

    @Named(value="group:list")
    @GET
    @Path(value="/groups")
    @ResponseParser(value=ParseKeySetFromJson.class)
    public Set<String> listGroups();

    @Named(value="group:get")
    @GET
    @Path(value="/groups/{name}")
    @Fallback(value=Fallbacks.NullOnNotFoundOr404.class)
    public Group getGroup(@PathParam(value="name") String var1);

    @Named(value="group:create")
    @POST
    @Path(value="/groups")
    public void createGroup(@WrapWith(value="groupname") String var1);

    @Named(value="group:update")
    @PUT
    @Path(value="/groups/{name}")
    public void updateGroup(@PathParam(value="name") @ParamParser(value=GroupName.class) @BinderParam(value=BindGroupToUpdateRequestJsonPayload.class) Group var1);

    @Named(value="group:delete")
    @DELETE
    @Path(value="/groups/{name}")
    public void deleteGroup(@PathParam(value="name") String var1);
}

