/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.glesys.compute;

import com.google.common.base.Charsets;
import com.google.common.base.Function;
import com.google.common.base.Joiner;
import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.base.Supplier;
import com.google.common.collect.FluentIterable;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.io.BaseEncoding;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.ListeningExecutorService;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import javax.annotation.Resource;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.jclouds.collect.Memoized;
import org.jclouds.compute.ComputeServiceAdapter;
import org.jclouds.compute.domain.Hardware;
import org.jclouds.compute.domain.HardwareBuilder;
import org.jclouds.compute.domain.Processor;
import org.jclouds.compute.domain.Template;
import org.jclouds.compute.domain.Volume;
import org.jclouds.compute.domain.internal.VolumeImpl;
import org.jclouds.compute.options.TemplateOptions;
import org.jclouds.compute.predicates.ImagePredicates;
import org.jclouds.compute.reference.ComputeServiceConstants;
import org.jclouds.compute.util.ComputeServiceUtils;
import org.jclouds.concurrent.FutureIterables;
import org.jclouds.domain.Location;
import org.jclouds.domain.LoginCredentials;
import org.jclouds.glesys.GleSYSApi;
import org.jclouds.glesys.GleSYSAsyncApi;
import org.jclouds.glesys.compute.options.GleSYSTemplateOptions;
import org.jclouds.glesys.domain.AllowedArgumentsForCreateServer;
import org.jclouds.glesys.domain.OSTemplate;
import org.jclouds.glesys.domain.Server;
import org.jclouds.glesys.domain.ServerDetails;
import org.jclouds.glesys.domain.ServerSpec;
import org.jclouds.glesys.options.CreateServerOptions;
import org.jclouds.glesys.options.DestroyServerOptions;
import org.jclouds.location.predicates.LocationPredicates;
import org.jclouds.logging.Logger;
import org.jclouds.util.Predicates2;

@Singleton
public class GleSYSComputeServiceAdapter
implements ComputeServiceAdapter<ServerDetails, Hardware, OSTemplate, String> {
    @Resource
    @Named(value="jclouds.compute")
    protected Logger logger = Logger.NULL;
    private final GleSYSApi api;
    private final GleSYSAsyncApi aapi;
    private final ListeningExecutorService userExecutor;
    private final ComputeServiceConstants.Timeouts timeouts;
    private final Supplier<Set<? extends Location>> locations;

    @Inject
    public GleSYSComputeServiceAdapter(GleSYSApi api, GleSYSAsyncApi aapi, @Named(value="jclouds.user-threads") ListeningExecutorService userExecutor, ComputeServiceConstants.Timeouts timeouts, @Memoized Supplier<Set<? extends Location>> locations) {
        this.api = (GleSYSApi)Preconditions.checkNotNull((Object)api, (Object)"api");
        this.aapi = (GleSYSAsyncApi)Preconditions.checkNotNull((Object)aapi, (Object)"aapi");
        this.userExecutor = (ListeningExecutorService)Preconditions.checkNotNull((Object)userExecutor, (Object)"userExecutor");
        this.timeouts = (ComputeServiceConstants.Timeouts)Preconditions.checkNotNull((Object)timeouts, (Object)"timeouts");
        this.locations = (Supplier)Preconditions.checkNotNull(locations, (Object)"locations");
    }

    public ComputeServiceAdapter.NodeAndInitialCredentials<ServerDetails> createNodeWithGroupEncodedIntoName(String group, String name, Template template) {
        Preconditions.checkNotNull((Object)template, (Object)"template was null");
        Preconditions.checkNotNull((Object)template.getOptions(), (Object)"template options was null");
        Preconditions.checkArgument((boolean)template.getOptions().getClass().isAssignableFrom(GleSYSTemplateOptions.class), (String)"options class %s should have been assignable from GleSYSTemplateOptions", (Object[])new Object[]{template.getOptions().getClass()});
        GleSYSTemplateOptions templateOptions = (GleSYSTemplateOptions)template.getOptions().as(GleSYSTemplateOptions.class);
        CreateServerOptions createServerOptions = new CreateServerOptions();
        createServerOptions.ip(templateOptions.getIp());
        Map md = ComputeServiceUtils.metadataAndTagsAsCommaDelimitedValue((TemplateOptions)template.getOptions());
        if (md.size() > 0) {
            String description = Joiner.on((char)'\n').withKeyValueSeparator("=").join(md);
            createServerOptions.description(BaseEncoding.base16().lowerCase().encode(description.getBytes(Charsets.UTF_8)));
        }
        ServerSpec.Builder<?> builder = ServerSpec.builder();
        builder.datacenter(template.getLocation().getId());
        builder.templateName(template.getImage().getId());
        builder.platform(template.getHardware().getHypervisor());
        builder.memorySizeMB(template.getHardware().getRam());
        builder.diskSizeGB(Math.round(((Volume)template.getHardware().getVolumes().get(0)).getSize().floatValue()));
        builder.cpuCores((int)((Processor)template.getHardware().getProcessors().get(0)).getCores());
        builder.transferGB(templateOptions.getTransferGB());
        ServerSpec spec = builder.build();
        String password = templateOptions.hasRootPassword() ? templateOptions.getRootPassword() : this.getRandomPassword();
        this.logger.debug(">> creating new Server spec(%s) name(%s) options(%s)", new Object[]{spec, name, createServerOptions});
        ServerDetails result = this.api.getServerApi().createWithHostnameAndRootPassword(spec, name, password, createServerOptions);
        this.logger.trace("<< server(%s)", new Object[]{result.getId()});
        return new ComputeServiceAdapter.NodeAndInitialCredentials((Object)result, result.getId() + "", LoginCredentials.builder().password(password).build());
    }

    private String getRandomPassword() {
        return UUID.randomUUID().toString().replace("-", "");
    }

    public Iterable<Hardware> listHardwareProfiles() {
        Set locationsSet = (Set)this.locations.get();
        ImmutableSet.Builder hardwareToReturn = ImmutableSet.builder();
        Iterable images = this.listImages();
        for (Map.Entry<String, AllowedArgumentsForCreateServer> platformToArgs : this.api.getServerApi().getAllowedArgumentsForCreateByPlatform().entrySet()) {
            for (String datacenter : platformToArgs.getValue().getDataCenters()) {
                for (int diskSizeGB : platformToArgs.getValue().getDiskSizesInGB().getAllowedUnits()) {
                    for (int cpuCores : platformToArgs.getValue().getCpuCoreOptions().getAllowedUnits()) {
                        for (int memorySizeMB : platformToArgs.getValue().getMemorySizesInMB().getAllowedUnits()) {
                            ImmutableSet.Builder templatesSupportedBuilder = ImmutableSet.builder();
                            for (OSTemplate template : images) {
                                if (!template.getPlatform().equals(platformToArgs.getKey()) || diskSizeGB < template.getMinDiskSize() || memorySizeMB < template.getMinMemSize()) continue;
                                templatesSupportedBuilder.add((Object)template.getName());
                            }
                            ImmutableSet templatesSupported = templatesSupportedBuilder.build();
                            if (templatesSupported.size() <= 0) continue;
                            hardwareToReturn.add((Object)new HardwareBuilder().ids(String.format("datacenter(%s)platform(%s)cpuCores(%d)memorySizeMB(%d)diskSizeGB(%d)", datacenter, platformToArgs.getKey(), cpuCores, memorySizeMB, diskSizeGB)).ram(memorySizeMB).processors((Iterable)ImmutableList.of((Object)new Processor((double)cpuCores, 1.0))).volumes((Iterable)ImmutableList.of((Object)new VolumeImpl(Float.valueOf(diskSizeGB), true, true))).hypervisor(platformToArgs.getKey()).location((Location)Iterables.find((Iterable)locationsSet, (Predicate)LocationPredicates.idEquals((String)datacenter))).supportsImage(ImagePredicates.idIn((Iterable)templatesSupported)).build());
                        }
                    }
                }
            }
        }
        return hardwareToReturn.build();
    }

    public Set<OSTemplate> listImages() {
        return this.api.getServerApi().listTemplates().toSet();
    }

    public OSTemplate getImage(final String id) {
        return (OSTemplate)Iterables.find((Iterable)this.listImages(), (Predicate)new Predicate<OSTemplate>(){

            public boolean apply(OSTemplate input) {
                return input.getName().equals(id);
            }
        }, null);
    }

    public Iterable<ServerDetails> listNodes() {
        return FutureIterables.transformParallel(this.api.getServerApi().list(), (Function)new Function<Server, ListenableFuture<? extends ServerDetails>>(){

            public ListenableFuture<ServerDetails> apply(Server from) {
                return GleSYSComputeServiceAdapter.this.aapi.getServerApi().get(from.getId());
            }
        }, (ListeningExecutorService)this.userExecutor, null, (Logger)this.logger, (String)"server details");
    }

    public Iterable<ServerDetails> listNodesByIds(final Iterable<String> ids) {
        return Iterables.filter(this.listNodes(), (Predicate)new Predicate<ServerDetails>(){

            public boolean apply(ServerDetails server) {
                return Iterables.contains((Iterable)ids, (Object)server.getId());
            }
        });
    }

    public Set<String> listLocations() {
        return FluentIterable.from(this.api.getServerApi().getAllowedArgumentsForCreateByPlatform().values()).transformAndConcat((Function)new Function<AllowedArgumentsForCreateServer, Set<String>>(){

            public Set<String> apply(AllowedArgumentsForCreateServer arg0) {
                return arg0.getDataCenters();
            }
        }).toSet();
    }

    public ServerDetails getNode(String id) {
        return this.api.getServerApi().get(id);
    }

    public void destroyNode(String id) {
        Predicates2.retry((Predicate)new Predicate<String>(){

            public boolean apply(String arg0) {
                try {
                    GleSYSComputeServiceAdapter.this.api.getServerApi().destroy(arg0, DestroyServerOptions.Builder.discardIp());
                    return true;
                }
                catch (IllegalStateException e) {
                    return false;
                }
            }
        }, (long)this.timeouts.nodeTerminated).apply((Object)id);
    }

    public void rebootNode(String id) {
        this.api.getServerApi().reboot(id);
    }

    public void resumeNode(String id) {
        this.api.getServerApi().start(id);
    }

    public void suspendNode(String id) {
        this.api.getServerApi().stop(id);
    }
}

