/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.glesys.compute.functions;

import com.google.common.base.Charsets;
import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.base.Splitter;
import com.google.common.base.Strings;
import com.google.common.base.Supplier;
import com.google.common.collect.FluentIterable;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Iterables;
import com.google.common.io.BaseEncoding;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import javax.annotation.Resource;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.jclouds.collect.Memoized;
import org.jclouds.compute.domain.HardwareBuilder;
import org.jclouds.compute.domain.Image;
import org.jclouds.compute.domain.NodeMetadata;
import org.jclouds.compute.domain.NodeMetadataBuilder;
import org.jclouds.compute.domain.OperatingSystem;
import org.jclouds.compute.domain.Processor;
import org.jclouds.compute.domain.internal.VolumeImpl;
import org.jclouds.compute.functions.GroupNamingConvention;
import org.jclouds.compute.util.ComputeServiceUtils;
import org.jclouds.domain.Location;
import org.jclouds.glesys.domain.Ip;
import org.jclouds.glesys.domain.Server;
import org.jclouds.glesys.domain.ServerDetails;
import org.jclouds.location.predicates.LocationPredicates;
import org.jclouds.logging.Logger;
import org.jclouds.util.InetAddresses2;

@Singleton
public class ServerDetailsToNodeMetadata
implements Function<ServerDetails, NodeMetadata> {
    @Resource
    @Named(value="jclouds.compute")
    protected Logger logger = Logger.NULL;
    public static final Map<Server.State, NodeMetadata.Status> serverStateToNodeStatus = ImmutableMap.builder().put((Object)Server.State.STOPPED, (Object)NodeMetadata.Status.SUSPENDED).put((Object)Server.State.LOCKED, (Object)NodeMetadata.Status.PENDING).put((Object)Server.State.RUNNING, (Object)NodeMetadata.Status.RUNNING).put((Object)Server.State.UNRECOGNIZED, (Object)NodeMetadata.Status.UNRECOGNIZED).build();
    protected final Supplier<Set<? extends Image>> images;
    protected final Supplier<Set<? extends Location>> locations;
    protected final GroupNamingConvention nodeNamingConvention;

    @Inject
    ServerDetailsToNodeMetadata(@Memoized Supplier<Set<? extends Location>> locations, @Memoized Supplier<Set<? extends Image>> images, GroupNamingConvention.Factory namingConvention) {
        this.nodeNamingConvention = ((GroupNamingConvention.Factory)Preconditions.checkNotNull((Object)namingConvention, (Object)"namingConvention")).createWithoutPrefix();
        this.locations = (Supplier)Preconditions.checkNotNull(locations, (Object)"locations");
        this.images = (Supplier)Preconditions.checkNotNull(images, (Object)"images");
    }

    public NodeMetadata apply(ServerDetails from) {
        NodeMetadataBuilder builder = new NodeMetadataBuilder();
        builder.ids(from.getId() + "");
        builder.name(from.getHostname());
        builder.hostname(from.getHostname());
        Location location = (Location)FluentIterable.from((Iterable)((Iterable)this.locations.get())).firstMatch(LocationPredicates.idEquals((String)from.getDatacenter())).orNull();
        Preconditions.checkState((location != null ? 1 : 0) != 0, (String)"no location matched ServerDetails %s", (Object[])new Object[]{from});
        builder.group(this.nodeNamingConvention.groupInUniqueNameOrNull(from.getHostname()));
        if (!Strings.isNullOrEmpty((String)from.getDescription()) && from.getDescription().matches("^[0-9A-Fa-f]+$")) {
            String decoded = new String(BaseEncoding.base16().lowerCase().decode((CharSequence)from.getDescription()), Charsets.UTF_8);
            ComputeServiceUtils.addMetadataAndParseTagsFromCommaDelimitedValue((NodeMetadataBuilder)builder, (Map)Splitter.on((char)'\n').withKeyValueSeparator("=").split((CharSequence)decoded));
        }
        builder.imageId(from.getTemplateName() + "");
        builder.operatingSystem(this.parseOperatingSystem(from));
        builder.hardware(new HardwareBuilder().ids(from.getId() + "").ram(from.getMemorySizeMB()).processors((Iterable)ImmutableList.of((Object)new Processor((double)from.getCpuCores(), 1.0))).volumes((Iterable)ImmutableList.of((Object)new VolumeImpl(Float.valueOf(from.getDiskSizeGB()), true, true))).hypervisor(from.getPlatform()).build());
        builder.status(serverStateToNodeStatus.get((Object)from.getState()));
        Iterable addresses = Iterables.filter((Iterable)Iterables.transform(from.getIps(), (Function)new Function<Ip, String>(){

            public String apply(Ip arg0) {
                return Strings.emptyToNull((String)arg0.getIp());
            }
        }), (Predicate)Predicates.notNull());
        builder.publicAddresses(Iterables.filter((Iterable)addresses, (Predicate)Predicates.not((Predicate)InetAddresses2.IsPrivateIPAddress.INSTANCE)));
        builder.privateAddresses(Iterables.filter((Iterable)addresses, (Predicate)InetAddresses2.IsPrivateIPAddress.INSTANCE));
        return builder.build();
    }

    protected OperatingSystem parseOperatingSystem(ServerDetails from) {
        try {
            return ((Image)Iterables.find((Iterable)((Iterable)this.images.get()), (Predicate)new FindImageForServer(from))).getOperatingSystem();
        }
        catch (NoSuchElementException e) {
            this.logger.debug("could not find a matching image for server %s", new Object[]{from});
            return null;
        }
    }

    private static class FindImageForServer
    implements Predicate<Image> {
        private final ServerDetails instance;

        private FindImageForServer(ServerDetails instance) {
            this.instance = instance;
        }

        public boolean apply(Image input) {
            return input.getProviderId().equals(this.instance.getTemplateName());
        }
    }
}

