/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.glesys.domain;

import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import java.beans.ConstructorProperties;

public class Cost {
    private final double amount;
    private final String currency;
    private final String timePeriod;

    public static Builder<?> builder() {
        return new ConcreteBuilder();
    }

    public Builder<?> toBuilder() {
        return new ConcreteBuilder().fromCost(this);
    }

    @ConstructorProperties(value={"amount", "currency", "timeperiod"})
    protected Cost(double amount, String currency, String timePeriod) {
        this.amount = amount;
        this.currency = (String)Preconditions.checkNotNull((Object)currency, (Object)"currency");
        this.timePeriod = (String)Preconditions.checkNotNull((Object)timePeriod, (Object)"timePeriod");
    }

    public double getAmount() {
        return this.amount;
    }

    public String getCurrency() {
        return this.currency;
    }

    public String getTimePeriod() {
        return this.timePeriod;
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.amount, this.currency, this.timePeriod});
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        Cost that = (Cost)Cost.class.cast(obj);
        return Objects.equal((Object)this.amount, (Object)that.amount) && Objects.equal((Object)this.currency, (Object)that.currency) && Objects.equal((Object)this.timePeriod, (Object)that.timePeriod);
    }

    protected Objects.ToStringHelper string() {
        return Objects.toStringHelper((String)"").add("amount", this.amount).add("currency", (Object)this.currency).add("timePeriod", (Object)this.timePeriod);
    }

    public String toString() {
        return this.string().toString();
    }

    private static class ConcreteBuilder
    extends Builder<ConcreteBuilder> {
        private ConcreteBuilder() {
        }

        @Override
        protected ConcreteBuilder self() {
            return this;
        }
    }

    public static abstract class Builder<T extends Builder<T>> {
        protected double amount;
        protected String currency;
        protected String timePeriod;

        protected abstract T self();

        public T amount(double amount) {
            this.amount = amount;
            return this.self();
        }

        public T currency(String currency) {
            this.currency = (String)Preconditions.checkNotNull((Object)currency, (Object)"currency");
            return this.self();
        }

        public T timePeriod(String timePeriod) {
            this.timePeriod = (String)Preconditions.checkNotNull((Object)timePeriod, (Object)"timePeriod");
            return this.self();
        }

        public Cost build() {
            return new Cost(this.amount, this.currency, this.timePeriod);
        }

        public T fromCost(Cost in) {
            return ((Builder)((Builder)this.amount(in.getAmount())).currency(in.getCurrency())).timePeriod(in.getTimePeriod());
        }
    }
}

