/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.glesys.domain;

import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import java.beans.ConstructorProperties;

public class EmailQuota {
    private final int max;
    private final String unit;

    public static Builder<?> builder() {
        return new ConcreteBuilder();
    }

    public Builder<?> toBuilder() {
        return new ConcreteBuilder().fromEmailAccount(this);
    }

    @ConstructorProperties(value={"max", "unit"})
    protected EmailQuota(int max, String unit) {
        this.max = max;
        this.unit = unit;
    }

    public int getMax() {
        return this.max;
    }

    public String getUnit() {
        return this.unit;
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.max, this.unit});
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        EmailQuota that = (EmailQuota)EmailQuota.class.cast(obj);
        return Objects.equal((Object)this.max, (Object)that.max) && Objects.equal((Object)this.unit, (Object)that.unit);
    }

    protected Objects.ToStringHelper string() {
        return Objects.toStringHelper((String)"").add("max", this.max).add("unit", (Object)this.unit);
    }

    public String toString() {
        return this.string().toString();
    }

    private static class ConcreteBuilder
    extends Builder<ConcreteBuilder> {
        private ConcreteBuilder() {
        }

        @Override
        protected ConcreteBuilder self() {
            return this;
        }
    }

    public static abstract class Builder<T extends Builder<T>> {
        protected int max;
        protected String unit;

        protected abstract T self();

        public T max(int max) {
            this.max = max;
            return this.self();
        }

        public T unit(String unit) {
            this.unit = (String)Preconditions.checkNotNull((Object)unit, (Object)"unit");
            return this.self();
        }

        public EmailQuota build() {
            return new EmailQuota(this.max, this.unit);
        }

        public T fromEmailAccount(EmailQuota in) {
            return ((Builder)this.max(in.getMax())).unit(in.getUnit());
        }
    }
}

