/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.glesys.domain;

import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import java.beans.ConstructorProperties;
import java.util.Date;

public class ResourceUsageValue {
    private final double value;
    private final Date timestamp;

    public static Builder<?> builder() {
        return new ConcreteBuilder();
    }

    public Builder<?> toBuilder() {
        return new ConcreteBuilder().fromResourceUsage(this);
    }

    @ConstructorProperties(value={"value", "timestamp"})
    protected ResourceUsageValue(double value, Date timestamp) {
        this.value = value;
        this.timestamp = (Date)Preconditions.checkNotNull((Object)timestamp, (Object)"timestamp");
    }

    public double getValue() {
        return this.value;
    }

    public Date getTimestamp() {
        return this.timestamp;
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.value, this.timestamp});
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        ResourceUsageValue that = (ResourceUsageValue)ResourceUsageValue.class.cast(obj);
        return Objects.equal((Object)this.value, (Object)that.value) && Objects.equal((Object)this.timestamp, (Object)that.timestamp);
    }

    protected Objects.ToStringHelper string() {
        return Objects.toStringHelper((String)"").add("value", this.value).add("timestamp", (Object)this.timestamp);
    }

    public String toString() {
        return this.string().toString();
    }

    private static class ConcreteBuilder
    extends Builder<ConcreteBuilder> {
        private ConcreteBuilder() {
        }

        @Override
        protected ConcreteBuilder self() {
            return this;
        }
    }

    public static abstract class Builder<T extends Builder<T>> {
        protected double value;
        protected Date timestamp;

        protected abstract T self();

        public T value(double value) {
            this.value = value;
            return this.self();
        }

        public T timestamp(Date timestamp) {
            this.timestamp = (Date)Preconditions.checkNotNull((Object)timestamp, (Object)"timestamp");
            return this.self();
        }

        public ResourceUsageValue build() {
            return new ResourceUsageValue(this.value, this.timestamp);
        }

        public T fromResourceUsage(ResourceUsageValue in) {
            return ((Builder)this.value(in.getValue())).timestamp(in.getTimestamp());
        }
    }
}

