/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.glesys.features;

import com.google.common.collect.FluentIterable;
import com.google.common.util.concurrent.ListenableFuture;
import java.util.Set;
import javax.inject.Named;
import javax.ws.rs.Consumes;
import javax.ws.rs.FormParam;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import org.jclouds.Fallbacks;
import org.jclouds.glesys.domain.Domain;
import org.jclouds.glesys.domain.DomainRecord;
import org.jclouds.glesys.options.AddDomainOptions;
import org.jclouds.glesys.options.AddRecordOptions;
import org.jclouds.glesys.options.DomainOptions;
import org.jclouds.glesys.options.UpdateRecordOptions;
import org.jclouds.http.filters.BasicAuthentication;
import org.jclouds.rest.annotations.Fallback;
import org.jclouds.rest.annotations.RequestFilters;
import org.jclouds.rest.annotations.SelectJson;

@RequestFilters(value={BasicAuthentication.class})
public interface DomainAsyncApi {
    @Named(value="domain:list")
    @POST
    @Path(value="/domain/list/format/json")
    @SelectJson(value={"domains"})
    @Consumes(value={"application/json"})
    @Fallback(value=Fallbacks.EmptyFluentIterableOnNotFoundOr404.class)
    public ListenableFuture<FluentIterable<Domain>> list();

    @Named(value="domain:details")
    @POST
    @Path(value="/domain/details/format/json")
    @SelectJson(value={"domain"})
    @Consumes(value={"application/json"})
    @Fallback(value=Fallbacks.NullOnNotFoundOr404.class)
    public ListenableFuture<Domain> get(@FormParam(value="domainname") String var1);

    @Named(value="domain:add")
    @POST
    @Path(value="/domain/add/format/json")
    @SelectJson(value={"domain"})
    @Consumes(value={"application/json"})
    public ListenableFuture<Domain> create(@FormParam(value="domainname") String var1, AddDomainOptions ... var2);

    @Named(value="domain:edit")
    @POST
    @Path(value="/domain/edit/format/json")
    @SelectJson(value={"domain"})
    @Consumes(value={"application/json"})
    public ListenableFuture<Domain> update(@FormParam(value="domainname") String var1, DomainOptions var2);

    @Named(value="domain:delete")
    @POST
    @Path(value="/domain/delete/format/json")
    public ListenableFuture<Void> delete(@FormParam(value="domainname") String var1);

    @Named(value="domain:listrecords")
    @POST
    @Path(value="/domain/listrecords/format/json")
    @SelectJson(value={"records"})
    @Consumes(value={"application/json"})
    public ListenableFuture<Set<DomainRecord>> listRecords(@FormParam(value="domainname") String var1);

    @Named(value="domain:addrecord")
    @POST
    @Path(value="/domain/addrecord/format/json")
    @SelectJson(value={"record"})
    @Consumes(value={"application/json"})
    public ListenableFuture<DomainRecord> createRecord(@FormParam(value="domainname") String var1, @FormParam(value="host") String var2, @FormParam(value="type") String var3, @FormParam(value="data") String var4, AddRecordOptions ... var5);

    @Named(value="domain:updaterecord")
    @POST
    @Path(value="/domain/updaterecord/format/json")
    @SelectJson(value={"record"})
    @Consumes(value={"application/json"})
    public ListenableFuture<DomainRecord> updateRecord(@FormParam(value="recordid") String var1, UpdateRecordOptions var2);

    @Named(value="domain:deleterecord")
    @POST
    @Path(value="/domain/deleterecord/format/json")
    public ListenableFuture<Void> deleteRecord(@FormParam(value="recordid") String var1);
}

