/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.glesys.functions.internal;

import com.google.common.base.Objects;
import com.google.gson.TypeAdapter;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonToken;
import com.google.gson.stream.JsonWriter;
import java.io.IOException;
import org.jclouds.glesys.domain.GleSYSBoolean;
import org.jclouds.glesys.domain.Server;

public class GleSYSTypeAdapters {

    public static class GleSYSBooleanAdapter
    extends TypeAdapter<GleSYSBoolean> {
        public void write(JsonWriter writer, GleSYSBoolean value) throws IOException {
            writer.value(value.getValue() ? "yes" : "no");
        }

        public GleSYSBoolean read(JsonReader in) throws IOException {
            if (in.peek() == JsonToken.BOOLEAN) {
                return new GleSYSBoolean(in.nextBoolean());
            }
            if (in.peek() == JsonToken.NULL) {
                return GleSYSBoolean.FALSE;
            }
            return new GleSYSBoolean(Objects.equal((Object)in.nextString(), (Object)"yes"));
        }
    }

    public static class ServerStateAdapter
    extends TypeAdapter<Server.State> {
        public void write(JsonWriter writer, Server.State value) throws IOException {
            writer.value(value.value());
        }

        public Server.State read(JsonReader reader) throws IOException {
            if (reader.peek() == JsonToken.NULL) {
                reader.nextNull();
                return Server.State.UNRECOGNIZED;
            }
            return Server.State.fromValue(reader.nextString());
        }
    }
}

