/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.fuseki;

import arq.cmd.CmdException;
import arq.cmdline.ArgDecl;
import arq.cmdline.ArgModuleGeneral;
import arq.cmdline.CmdARQ;
import arq.cmdline.ModDatasetAssembler;
import com.hp.hpl.jena.query.ARQ;
import com.hp.hpl.jena.query.Dataset;
import com.hp.hpl.jena.sparql.core.DatasetGraph;
import com.hp.hpl.jena.sparql.core.DatasetGraphFactory;
import com.hp.hpl.jena.tdb.TDB;
import com.hp.hpl.jena.tdb.TDBFactory;
import java.io.InputStream;
import java.net.BindException;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.List;
import org.apache.jena.fuseki.Fuseki;
import org.apache.jena.fuseki.mgt.ManagementServer;
import org.apache.jena.fuseki.server.FusekiConfig;
import org.apache.jena.fuseki.server.SPARQLServer;
import org.apache.jena.fuseki.server.ServerConfig;
import org.eclipse.jetty.server.Server;
import org.openjena.atlas.io.IO;
import org.openjena.atlas.lib.FileOps;
import org.openjena.atlas.lib.Sink;
import org.openjena.riot.Lang;
import org.openjena.riot.RiotLoader;
import org.openjena.riot.lang.SinkQuadsToDataset;
import org.openjena.riot.lang.SinkTriplesToGraph;
import org.slf4j.Logger;

public class FusekiCmd
extends CmdARQ {
    private static ArgDecl argMgtPort = new ArgDecl(true, "mgtPort", "mgtport");
    private static ArgDecl argMem = new ArgDecl(false, "mem");
    private static ArgDecl argAllowUpdate = new ArgDecl(false, "update", "allowUpdate");
    private static ArgDecl argFile = new ArgDecl(true, "file");
    private static ArgDecl argMemTDB = new ArgDecl(false, "memtdb", "memTDB");
    private static ArgDecl argTDB = new ArgDecl(true, "loc", "location");
    private static ArgDecl argPort = new ArgDecl(true, "port");
    private static ArgDecl argHost = new ArgDecl(true, "host");
    private static ArgDecl argTimeout = new ArgDecl(true, "timeout");
    private static ArgDecl argFusekiConfig = new ArgDecl(true, "config", "conf");
    private static ArgDecl argJettyConfig = new ArgDecl(true, "jetty-config");
    private static ArgDecl argGZip = new ArgDecl(true, "gzip");
    private static ArgDecl argHome = new ArgDecl(true, "home");
    private static ArgDecl argPages = new ArgDecl(true, "pages");
    private static ModDatasetAssembler modDataset = new ModDatasetAssembler();
    private int port = 3030;
    private int mgtPort = -1;
    private String clientHost = null;
    private DatasetGraph dsg;
    private String datasetPath;
    private boolean allowUpdate = false;
    private String fusekiConfigFile = null;
    private boolean enableCompression = true;
    private String jettyConfigFile = null;
    private String homeDir = null;
    private String pagesDir;
    static String argUsage = "[--config=FILE] [--mem|--desc=AssemblerFile|--file=FILE] [--port PORT] [--host HOST] /DatasetPathName";

    public static void main(String ... argv) {
        ARQ.init();
        TDB.init();
        Fuseki.init();
        new FusekiCmd(argv).mainRun();
    }

    public FusekiCmd(String ... argv) {
        super(argv);
        this.getUsage().startCategory("Fuseki");
        this.addModule((ArgModuleGeneral)modDataset);
        this.add(argMem, "--mem", "Create an in-memory, non-persistent dataset for the server");
        this.add(argFile, "--file=FILE", "Create an in-memory, non-persistent dataset for the server, initialised with the contents of the file");
        this.add(argTDB, "--loc=DIR", "Use an existing TDB database (or create if does not exist)");
        this.add(argMemTDB, "--memTDB", "Create an in-memory, non-persistent dataset using TDB (testing only)");
        this.add(argPort, "--port", "Listen on this port number");
        this.add(argPages, "--pages=DIR", "Set of pages to serve as static content");
        this.add(argTimeout, "--timeout", "Global timeout applied to queries (value in ms) -- format is X[,Y] ");
        this.add(argAllowUpdate, "--update", "Allow updates (via SPARQL Update and SPARQL HTTP Update)");
        this.add(argFusekiConfig, "--config=", "Use a configuration file to determine the services");
        this.add(argJettyConfig, "--jetty-config=", "Set up the server (not services) with a Jetty XML file");
        this.add(argMgtPort, "--mgt=port", "Enable the management commands on the given port");
        this.add(argHome, "--home=DIR", "Root of Fuseki installation (overrides environment variable FUSEKI_HOME)");
        this.add(argGZip, "--gzip=on|off", "Enable GZip compression (HTTP Accept-Encoding) if request header set");
        this.modVersion.addClass(TDB.class);
        this.modVersion.addClass(Fuseki.class);
    }

    protected String getSummary() {
        return this.getCommandName() + " " + argUsage;
    }

    protected void processModulesAndArgs() {
        List args;
        int x = 0;
        Logger log = Fuseki.serverLog;
        if (this.contains(argFusekiConfig)) {
            this.fusekiConfigFile = this.getValue(argFusekiConfig);
        }
        ArgDecl assemblerDescDecl = new ArgDecl(true, "desc", "dataset");
        if (this.contains(argMem)) {
            ++x;
        }
        if (this.contains(argFile)) {
            ++x;
        }
        if (this.contains(assemblerDescDecl)) {
            ++x;
        }
        if (this.contains(argTDB)) {
            ++x;
        }
        if (this.fusekiConfigFile != null) {
            if (x > 1) {
                throw new CmdException("Dataset specificed on the command line and also a configuration file specificed.");
            }
        } else if (x == 0) {
            throw new CmdException("Required: either --config=FILE or one of --mem, --file, --loc or --desc");
        }
        TDB.setOptimizerWarningFlag((boolean)false);
        if (this.contains(argMem)) {
            log.info("Dataset: in-memory");
            this.dsg = DatasetGraphFactory.createMem();
        }
        if (this.contains(argFile)) {
            this.dsg = DatasetGraphFactory.createMem();
            String filename = this.getValue(argFile);
            log.info("Dataset: in-memory: load file: " + filename);
            if (!FileOps.exists((String)filename)) {
                throw new CmdException("File not found: " + filename);
            }
            Lang language = Lang.guess((String)filename);
            if (language == null) {
                throw new CmdException("Can't guess language for file: " + filename);
            }
            InputStream input = IO.openFile((String)filename);
            if (language.isQuads()) {
                SinkQuadsToDataset sink = new SinkQuadsToDataset(this.dsg);
                RiotLoader.readQuads((InputStream)input, (Lang)language, (String)filename, (Sink)sink);
            } else {
                SinkTriplesToGraph sink = new SinkTriplesToGraph(this.dsg.getDefaultGraph());
                RiotLoader.readTriples((InputStream)input, (Lang)language, (String)filename, (Sink)sink);
            }
        }
        if (this.contains(argMemTDB)) {
            log.info("TDB dataset: in-memory");
            this.dsg = TDBFactory.createDatasetGraph();
        }
        if (this.contains(argTDB)) {
            String dir = this.getValue(argTDB);
            log.info("TDB dataset: directory=" + dir);
            if (!FileOps.exists((String)dir)) {
                throw new CmdException("Directory not found: " + dir);
            }
            this.dsg = TDBFactory.createDatasetGraph((String)dir);
        }
        if (this.contains(assemblerDescDecl)) {
            log.info("Dataset from assembler");
            Dataset ds = modDataset.createDataset();
            if (ds != null) {
                this.dsg = ds.asDatasetGraph();
            }
        }
        if (this.contains(argFusekiConfig)) {
            if (this.dsg != null) {
                throw new CmdException("Dataset specificed on the command line and also a configuration file specificed.");
            }
            this.fusekiConfigFile = this.getValue(argFusekiConfig);
        }
        if (this.contains(argPort)) {
            String portStr = this.getValue(argPort);
            try {
                this.port = Integer.parseInt(portStr);
            }
            catch (NumberFormatException ex) {
                throw new CmdException(argPort.getKeyName() + " : bad port number: " + portStr);
            }
        }
        if (this.contains(argMgtPort)) {
            String mgtPortStr = this.getValue(argMgtPort);
            try {
                this.mgtPort = Integer.parseInt(mgtPortStr);
            }
            catch (NumberFormatException ex) {
                throw new CmdException(argMgtPort.getKeyName() + " : bad port number: " + mgtPortStr);
            }
        }
        if (this.contains(argHost)) {
            this.clientHost = this.getValue(argHost);
            try {
                InetAddress.getByName(this.clientHost);
            }
            catch (UnknownHostException e) {
                throw new CmdException("unknown host name");
            }
        }
        if (this.fusekiConfigFile == null && this.dsg == null) {
            throw new CmdException("No dataset defined and no configuration file: " + argUsage);
        }
        if (this.dsg != null) {
            if (this.getPositional().size() == 0) {
                throw new CmdException("No dataset path name given");
            }
            if (this.getPositional().size() > 1) {
                throw new CmdException("Multiple dataset path names given");
            }
            this.datasetPath = this.getPositionalArg(0);
            if (this.datasetPath.length() > 0 && !this.datasetPath.startsWith("/")) {
                throw new CmdException("Dataset path name must begin with a /: " + this.datasetPath);
            }
            this.allowUpdate = this.contains(argAllowUpdate);
        }
        if (this.contains(argTimeout)) {
            String str = this.getValue(argTimeout);
            ARQ.getContext().set(ARQ.queryTimeout, (Object)str);
        }
        if (this.contains(argJettyConfig)) {
            this.jettyConfigFile = this.getValue(argJettyConfig);
            if (!FileOps.exists((String)this.jettyConfigFile)) {
                throw new CmdException("No such file: : " + this.jettyConfigFile);
            }
        }
        if (this.contains(argHome)) {
            args = super.getValues(argHome);
            this.homeDir = (String)args.get(args.size() - 1);
        }
        if (this.contains(argPages)) {
            args = super.getValues(argPages);
            this.pagesDir = (String)args.get(args.size() - 1);
        }
        if (this.contains(argGZip)) {
            if (!this.hasValueOfTrue(argGZip) && !this.hasValueOfFalse(argGZip)) {
                throw new CmdException((String)argGZip.getNames().get(0) + ": Not understood: " + this.getValue(argGZip));
            }
            this.enableCompression = super.hasValueOfTrue(argGZip);
        }
    }

    private static String sort_out_dir(String path) {
        path.replace('\\', '/');
        if (!path.endsWith("/")) {
            path = path + "/";
        }
        return path;
    }

    protected void exec() {
        ServerConfig serverConfig;
        String staticContentDir;
        if (this.homeDir == null) {
            this.homeDir = System.getenv(Fuseki.FusekiHomeEnv) != null ? System.getenv(Fuseki.FusekiHomeEnv) : ".";
        }
        this.homeDir = FusekiCmd.sort_out_dir(this.homeDir);
        if (!FileOps.exists((String)this.homeDir)) {
            Fuseki.configLog.warn("No such directory for Fuseki home: " + this.homeDir);
        }
        if ((staticContentDir = this.pagesDir) == null) {
            staticContentDir = this.homeDir + Fuseki.PagesStatic;
        }
        Fuseki.configLog.debug("Static content: " + staticContentDir);
        if (!FileOps.exists((String)staticContentDir)) {
            Fuseki.configLog.warn("No such directory for static content: " + staticContentDir);
        }
        if (this.jettyConfigFile != null) {
            Fuseki.configLog.info("Jetty configuration: " + this.jettyConfigFile);
        }
        if (this.fusekiConfigFile != null) {
            Fuseki.configLog.info("Configuration file: " + this.fusekiConfigFile);
            serverConfig = FusekiConfig.configure(this.fusekiConfigFile);
        } else {
            serverConfig = FusekiConfig.defaultConfiguration(this.datasetPath, this.dsg, this.allowUpdate);
        }
        serverConfig.port = this.port;
        serverConfig.pages = staticContentDir;
        serverConfig.mgtPort = this.mgtPort;
        serverConfig.pagesPort = this.port;
        serverConfig.enableCompression = this.enableCompression;
        serverConfig.jettyConfigFile = this.jettyConfigFile;
        SPARQLServer server = new SPARQLServer(serverConfig);
        Fuseki.setServer(server);
        Server mgtServer = null;
        if (this.mgtPort > 0) {
            Fuseki.configLog.info("Management services on port " + this.mgtPort);
            mgtServer = ManagementServer.createManagementServer(this.mgtPort);
            try {
                mgtServer.start();
            }
            catch (BindException ex) {
                Fuseki.serverLog.error("SPARQLServer: Failed to start management server: " + ex.getMessage());
                System.exit(1);
            }
            catch (Exception ex) {
                Fuseki.serverLog.error("SPARQLServer: Failed to start management server: " + ex.getMessage(), (Throwable)ex);
                System.exit(1);
            }
        }
        server.start();
        try {
            server.getServer().join();
        }
        catch (Exception ex) {
            // empty catch block
        }
        if (mgtServer != null) {
            try {
                mgtServer.stop();
            }
            catch (Exception e) {
                Fuseki.serverLog.warn("Failed to cleanly stop the management server", (Throwable)e);
            }
        }
        System.exit(0);
    }

    protected String getCommandName() {
        return "fuseki";
    }
}

