/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.fuseki.http;

import com.hp.hpl.jena.graph.Graph;
import com.hp.hpl.jena.graph.Node;
import com.hp.hpl.jena.rdf.model.Model;
import com.hp.hpl.jena.rdf.model.ModelFactory;
import org.apache.jena.fuseki.DatasetAccessor;
import org.apache.jena.fuseki.http.DatasetGraphAccessor;

public class DatasetAdapter
implements DatasetAccessor {
    private final DatasetGraphAccessor updater;

    public DatasetAdapter(DatasetGraphAccessor updater) {
        this.updater = updater;
    }

    @Override
    public Model getModel() {
        Graph g = this.updater.httpGet();
        return ModelFactory.createModelForGraph((Graph)g);
    }

    @Override
    public Model getModel(String graphUri) {
        Graph g = this.updater.httpGet(Node.createURI((String)graphUri));
        if (g == null) {
            return null;
        }
        return ModelFactory.createModelForGraph((Graph)g);
    }

    @Override
    public boolean containsModel(String graphUri) {
        return this.updater.httpHead(Node.createURI((String)graphUri));
    }

    @Override
    public void putModel(Model data) {
        this.updater.httpPut(data.getGraph());
    }

    @Override
    public void putModel(String graphUri, Model data) {
        this.updater.httpPut(Node.createURI((String)graphUri), data.getGraph());
    }

    @Override
    public void deleteDefault() {
        this.updater.httpDelete();
    }

    @Override
    public void deleteModel(String graphUri) {
        this.updater.httpDelete(Node.createURI((String)graphUri));
    }

    @Override
    public void add(Model data) {
        this.updater.httpPost(data.getGraph());
    }

    @Override
    public void add(String graphUri, Model data) {
        this.updater.httpPost(Node.createURI((String)graphUri), data.getGraph());
    }
}

