/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.fuseki.mgt;

import com.hp.hpl.jena.shared.PrefixMapping;
import com.hp.hpl.jena.sparql.core.DatasetGraph;
import com.hp.hpl.jena.sparql.core.Prologue;
import com.hp.hpl.jena.sparql.serializer.PrologueSerializer;
import com.hp.hpl.jena.tdb.store.DatasetGraphTDB;
import java.util.Iterator;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import org.apache.jena.fuseki.server.DatasetRef;
import org.apache.jena.fuseki.server.DatasetRegistry;
import org.openjena.atlas.io.IndentedLineBuffer;
import org.openjena.atlas.io.IndentedWriter;
import org.openjena.atlas.iterator.Iter;

public class MgtFunctions {
    public static String dataset(HttpServletRequest request, String dftValue) {
        String ds = MgtFunctions.dataset(request);
        if (ds == null) {
            return dftValue;
        }
        return ds;
    }

    public static String dataset(HttpServletRequest request) {
        HttpSession session = request.getSession(false);
        if (session == null) {
            return "No session";
        }
        String ds = (String)session.getAttribute("dataset");
        return ds;
    }

    public static DatasetRef datasetDesc(HttpServletRequest request) {
        HttpSession session = request.getSession(false);
        if (session == null) {
            return null;
        }
        String ds = (String)session.getAttribute("dataset");
        return (DatasetRef)DatasetRegistry.get().get(ds);
    }

    public static List<String> datasets(HttpServletRequest request) {
        return Iter.toList(DatasetRegistry.get().keys());
    }

    public static String actionDataset(HttpServletRequest request) {
        return "/$/datasets";
    }

    public static String serviceQuery(String dataset) {
        DatasetRef ref = (DatasetRef)DatasetRegistry.get().get(dataset);
        return MgtFunctions.serviceNameOrDefault(ref.queryEP, "sparql");
    }

    public static String serviceUpdate(String dataset) {
        DatasetRef ref = (DatasetRef)DatasetRegistry.get().get(dataset);
        return MgtFunctions.serviceNameOrDefault(ref.updateEP, "update");
    }

    public static String serviceUpload(String dataset) {
        DatasetRef ref = (DatasetRef)DatasetRegistry.get().get(dataset);
        return MgtFunctions.serviceNameOrDefault(ref.uploadEP, "upload");
    }

    public static String serviceGraphRead(String dataset) {
        DatasetRef ref = (DatasetRef)DatasetRegistry.get().get(dataset);
        return MgtFunctions.serviceNameOrDefault(ref.readGraphStoreEP, "get");
    }

    public static String serviceGraphReadWrite(String dataset) {
        DatasetRef ref = (DatasetRef)DatasetRegistry.get().get(dataset);
        return MgtFunctions.serviceNameOrDefault(ref.readWriteGraphStoreEP, "data");
    }

    private static String serviceNameOrDefault(List<String> services, String defaultValue) {
        if (services.isEmpty()) {
            return defaultValue;
        }
        String x = services.get(0);
        if (x.startsWith("/")) {
            x = x.substring(1);
        }
        return x;
    }

    @Deprecated
    public static String datasetsAsSelectOptions(HttpServletRequest request) {
        StringBuilder buff = new StringBuilder();
        Iterator<String> iter = DatasetRegistry.get().keys();
        while (iter.hasNext()) {
            String name = iter.next();
            buff.append("<option value=\"" + name + "\">" + name + "</option>");
        }
        return buff.toString();
    }

    @Deprecated
    public static String datasetsAsListItems(HttpServletRequest request) {
        StringBuilder buff = new StringBuilder();
        Iterator<String> iter = DatasetRegistry.get().keys();
        while (iter.hasNext()) {
            String name = iter.next();
            buff.append("  <li>" + name + "</li>");
        }
        return buff.toString();
    }

    public static String prefixes(HttpServletRequest request) {
        String dsName = MgtFunctions.dataset(request);
        DatasetRef desc = (DatasetRef)DatasetRegistry.get().get(dsName);
        if (desc == null) {
            return "<not found>";
        }
        DatasetGraph dsg = desc.dataset;
        if (dsg instanceof DatasetGraphTDB) {
            PrefixMapping pmap = ((DatasetGraphTDB)dsg).getPrefixes().getPrefixMapping();
            Prologue prologue = new Prologue(pmap);
            IndentedLineBuffer buff = new IndentedLineBuffer();
            PrologueSerializer.output((IndentedWriter)buff, (Prologue)prologue);
            buff.append("\n", new Object[0]);
            return buff.asString();
        }
        return "";
    }
}

