/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.fuseki.migrate;

import com.hp.hpl.jena.graph.BulkUpdateHandler;
import com.hp.hpl.jena.graph.Graph;
import com.hp.hpl.jena.graph.Triple;
import com.hp.hpl.jena.graph.impl.GraphWithPerform;
import com.hp.hpl.jena.graph.impl.WrappedBulkUpdateHandler;
import java.util.Iterator;
import java.util.List;
import org.apache.jena.fuseki.migrate.LimitingGraph;

public class LimitingBulkUpdateHandler
extends WrappedBulkUpdateHandler {
    LimitingGraph lGraph;

    public LimitingBulkUpdateHandler(LimitingGraph graph, BulkUpdateHandler bulk) {
        super((GraphWithPerform)graph, bulk);
        this.lGraph = graph;
    }

    public void add(Triple[] triples) {
        this.lGraph.count += triples.length;
        this.lGraph.checkSize();
        super.add(triples);
    }

    public void add(List<Triple> triples) {
        this.lGraph.count += triples.size();
        this.lGraph.checkSize();
        super.add(triples);
    }

    public void add(Iterator<Triple> it) {
        while (it.hasNext()) {
            Triple t = it.next();
            ++this.lGraph.count;
            this.lGraph.checkSize();
            this.graph.add(t);
        }
    }

    public void add(Graph g, boolean withReifications) {
        this.lGraph.count += g.size();
        this.lGraph.checkSize();
        super.add(g, withReifications);
    }

    public void add(Graph g) {
        this.lGraph.count += g.size();
        this.lGraph.checkSize();
        super.add(g);
    }
}

