/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.fuseki.migrate;

import com.hp.hpl.jena.graph.BulkUpdateHandler;
import com.hp.hpl.jena.graph.Graph;
import com.hp.hpl.jena.graph.Triple;
import com.hp.hpl.jena.graph.impl.GraphWithPerform;
import com.hp.hpl.jena.graph.impl.WrappedGraph;
import com.hp.hpl.jena.shared.AddDeniedException;
import org.apache.jena.fuseki.migrate.LimitingBulkUpdateHandler;

public class LimitingGraph
extends WrappedGraph
implements GraphWithPerform {
    int limit = 10000;
    int count = 0;
    LimitingBulkUpdateHandler bulk;

    public LimitingGraph(Graph graph, int triplesLimit) {
        super(graph);
        this.limit = triplesLimit;
        this.bulk = new LimitingBulkUpdateHandler(this, graph.getBulkUpdateHandler());
    }

    public void add(Triple t) throws AddDeniedException {
        ++this.count;
        this.checkSize();
        super.add(t);
    }

    public BulkUpdateHandler getBulkUpdateHandler() {
        return this.bulk;
    }

    void checkSize() {
        if (this.count > this.limit) {
            throw new AddDeniedException("Attempt to exceed graph limit (" + this.limit + ")");
        }
    }
}

