/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.fuseki.servlets;

import com.hp.hpl.jena.query.ReadWrite;
import com.hp.hpl.jena.shared.Lock;
import com.hp.hpl.jena.sparql.SystemARQ;
import com.hp.hpl.jena.sparql.core.DatasetGraph;
import com.hp.hpl.jena.sparql.core.Transactional;
import com.hp.hpl.jena.tdb.migrate.DatasetGraphWithLock;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.openjena.atlas.logging.Log;

public class HttpAction {
    public final long id;
    private final DatasetGraph dsg;
    private final Transactional transactional;
    private DatasetGraph activeDSG;
    public final HttpServletRequest request;
    public final HttpServletResponse response;
    public final boolean verbose;

    public HttpAction(long id, DatasetGraph dsg, HttpServletRequest request, HttpServletResponse response, boolean verbose) {
        this.id = id;
        this.dsg = dsg;
        if (dsg instanceof Transactional) {
            this.transactional = (Transactional)dsg;
        } else {
            DatasetGraphWithLock dsglock = new DatasetGraphWithLock(dsg);
            this.transactional = dsglock;
            dsg = dsglock;
        }
        this.request = request;
        this.response = response;
        this.verbose = verbose;
    }

    public void beginRead() {
        this.transactional.begin(ReadWrite.READ);
        this.activeDSG = this.dsg;
    }

    public void endRead() {
        this.transactional.end();
        this.activeDSG = null;
    }

    public void beginWrite() {
        this.transactional.begin(ReadWrite.WRITE);
        this.activeDSG = this.dsg;
    }

    public void commit() {
        this.transactional.commit();
        this.activeDSG = null;
    }

    public void abort() {
        this.transactional.abort();
        this.activeDSG = null;
    }

    public void endWrite() {
        if (this.transactional.isInTransaction()) {
            Log.warn((Object)this, (String)"Transaction still active in endWriter - no commit or abort seen (forced abort)");
            try {
                this.transactional.abort();
            }
            catch (RuntimeException ex) {
                Log.warn((Object)this, (String)"Exception in forced abort (trying to continue)", (Throwable)ex);
            }
        }
        this.transactional.end();
        this.activeDSG = null;
    }

    public final DatasetGraph getActiveDSG() {
        return this.activeDSG;
    }

    private void enter(DatasetGraph dsg, Lock lock, boolean readLock) {
        if (lock == null && dsg == null) {
            return;
        }
        if (lock == null) {
            lock = dsg.getLock();
        }
        if (lock == null) {
            return;
        }
        lock.enterCriticalSection(readLock);
    }

    private void leave(DatasetGraph dsg, Lock lock, boolean readLock) {
        if (lock == null && dsg == null) {
            return;
        }
        if (lock == null) {
            lock = dsg.getLock();
        }
        if (lock == null) {
            return;
        }
        lock.leaveCriticalSection();
    }

    public void sync() {
        SystemARQ.sync((DatasetGraph)this.dsg);
    }
}

