/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.fuseki.servlets;

import com.hp.hpl.jena.rdf.model.Model;
import com.hp.hpl.jena.rdf.model.RDFWriter;
import com.hp.hpl.jena.xmloutput.RDFXMLWriterI;
import java.io.OutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.jena.fuseki.DEF;
import org.apache.jena.fuseki.Fuseki;
import org.apache.jena.fuseki.FusekiLib;
import org.apache.jena.fuseki.conneg.ConNeg;
import org.apache.jena.fuseki.conneg.WebLib;
import org.apache.jena.fuseki.servlets.ResponseResultSet;
import org.apache.jena.fuseki.servlets.SPARQL_ServletBase;
import org.openjena.atlas.web.MediaType;
import org.openjena.atlas.web.TypedInputStream;
import org.openjena.riot.Lang;

public class ResponseModel {
    public static void doResponseModel(Model model, HttpServletRequest request, HttpServletResponse response) {
        TypedInputStream ts;
        Lang lang;
        RDFWriter rdfw;
        String mimeType = null;
        MediaType i = ConNeg.chooseContentType(request, DEF.rdfOffer, DEF.acceptRDFXML);
        if (i != null) {
            mimeType = i.getContentType();
        }
        String writerMimeType = mimeType;
        if (mimeType == null) {
            Fuseki.requestLog.warn("Can't find MIME type for response");
            String x = WebLib.getAccept(request);
            String msg = x == null ? "No Accept: header" : "Accept: " + x + " : Not understood";
            SPARQL_ServletBase.error(406, msg);
        }
        if ((rdfw = FusekiLib.chooseWriter(lang = FusekiLib.langFromContentType((ts = new TypedInputStream(null, mimeType, "utf-8")).getMediaType()))) instanceof RDFXMLWriterI) {
            rdfw.setProperty("showXmlDeclaration", (Object)"true");
        }
        try {
            ResponseResultSet.setHttpResponse(request, response, ts.getMediaType(), ts.getCharset());
            response.setStatus(200);
            rdfw.write(model, (OutputStream)response.getOutputStream(), null);
            response.getOutputStream().flush();
        }
        catch (Exception ex) {
            SPARQL_ServletBase.errorOccurred(ex);
        }
    }
}

