/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.fuseki.servlets;

import com.hp.hpl.jena.query.QueryParseException;
import com.hp.hpl.jena.query.Syntax;
import com.hp.hpl.jena.sparql.core.DatasetGraph;
import com.hp.hpl.jena.update.UpdateAction;
import com.hp.hpl.jena.update.UpdateException;
import com.hp.hpl.jena.update.UpdateFactory;
import com.hp.hpl.jena.update.UpdateRequest;
import java.io.IOException;
import java.io.InputStream;
import java.util.Enumeration;
import javax.servlet.ServletException;
import javax.servlet.ServletInputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.jena.fuseki.Fuseki;
import org.apache.jena.fuseki.FusekiLib;
import org.apache.jena.fuseki.servlets.SPARQL_Protocol;
import org.apache.jena.fuseki.servlets.SPARQL_ServletBase;
import org.openjena.atlas.io.IO;
import org.openjena.atlas.lib.Bytes;
import org.openjena.riot.ContentType;

public class SPARQL_Update
extends SPARQL_Protocol {
    private static String updateParseBase = "http://example/base/";

    public SPARQL_Update(boolean verbose) {
        super(SPARQL_ServletBase.PlainRequestFlag.REGULAR, verbose);
    }

    public SPARQL_Update() {
        this(false);
    }

    protected void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        response.sendError(400, "Attempt to perform SPARQL update by GET.  Use POST");
    }

    protected void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        this.doCommon(request, response);
    }

    protected void doOptions(HttpServletRequest request, HttpServletResponse response) {
        response.setHeader("Allow", "OPTIONS,POST");
        response.setHeader("Content-Length", "0");
    }

    @Override
    protected boolean requestNoQueryString(HttpServletRequest request, HttpServletResponse response) {
        if ("POST".equals(request.getMethod().toUpperCase())) {
            return true;
        }
        SPARQL_Update.errorOccurred("Bad!");
        return false;
    }

    @Override
    protected void perform(long id, DatasetGraph dsg, HttpServletRequest request, HttpServletResponse response) {
        this.validate(request);
        HttpActionUpdate action = new HttpActionUpdate(id, dsg, request, response, this.verbose_debug);
        ContentType incoming = FusekiLib.contentType(request);
        String ctStr = incoming == null ? "application/sparql-update" : incoming.getContentType();
        if ("application/sparql-update".equals(ctStr)) {
            this.executeBody(action);
            return;
        }
        if ("application/x-www-form-urlencoded".equals(ctStr)) {
            this.executeForm(action);
            return;
        }
        SPARQL_Update.error(415, "Bad content type: " + request.getContentType());
    }

    private void validate(HttpServletRequest request) {
        ContentType incoming = FusekiLib.contentType(request);
        String ctStr = incoming == null ? "application/sparql-update" : incoming.getContentType();
        if ("application/sparql-update".equals(ctStr)) {
            String charset;
            Enumeration en;
            if (request.getQueryString() != null) {
                SPARQL_Update.errorBadRequest("No query string allowed: found: " + request.getQueryString());
            }
            if ((en = request.getParameterNames()).hasMoreElements()) {
                SPARQL_Update.errorBadRequest("No request parameters allowed");
            }
            if ((charset = request.getCharacterEncoding()) != null && !charset.equalsIgnoreCase("utf-8")) {
                SPARQL_Update.errorBadRequest("Bad charset: " + charset);
            }
            return;
        }
        if ("application/x-www-form-urlencoded".equals(ctStr)) {
            String requestStr = request.getParameter("update");
            if (requestStr == null) {
                requestStr = request.getParameter("request");
            }
            if (requestStr == null) {
                SPARQL_Update.errorBadRequest("SPARQL Update: No update= in HTML form");
            }
            Enumeration en = request.getParameterNames();
            while (en.hasMoreElements()) {
                String name = (String)en.nextElement();
                if (name.equals("request") || name.equals("update")) continue;
                SPARQL_Update.errorBadRequest("SPARQL Update: Unrecognized update request parameter: " + name);
            }
            return;
        }
        SPARQL_Update.error(415, "Must be application/sparql-update or application/x-www-form-urlencoded (got " + ctStr + ")");
    }

    private void executeBody(HttpActionUpdate action) {
        UpdateRequest req;
        ServletInputStream input = null;
        try {
            input = action.request.getInputStream();
        }
        catch (IOException ex) {
            SPARQL_Update.errorOccurred(ex);
        }
        try {
            if (action.verbose) {
                byte[] b = IO.readWholeFile((InputStream)input);
                String requestStr = Bytes.bytes2string((byte[])b);
                String requestStrLog = SPARQL_Update.formatForLog(requestStr);
                Fuseki.requestLog.info(String.format("[%d] Update = %s", action.id, requestStrLog));
                req = UpdateFactory.create((String)requestStr, (Syntax)Syntax.syntaxARQ);
            } else {
                req = UpdateFactory.read((InputStream)input, (Syntax)Syntax.syntaxARQ);
            }
        }
        catch (UpdateException ex) {
            SPARQL_Update.errorBadRequest(ex.getMessage());
            req = null;
        }
        catch (QueryParseException ex) {
            SPARQL_Update.errorBadRequest(SPARQL_Update.messageForQPE(ex));
            req = null;
        }
        this.execute(action, req);
        SPARQL_Update.successNoContent(action);
    }

    private void executeForm(HttpActionUpdate action) {
        UpdateRequest req;
        String requestStr = action.request.getParameter("update");
        if (requestStr == null) {
            requestStr = action.request.getParameter("request");
        }
        if (action.verbose) {
            Fuseki.requestLog.info(String.format("[%d] Form update = %s", action.id, SPARQL_Update.formatForLog(requestStr)));
        }
        try {
            req = UpdateFactory.create((String)requestStr, (String)updateParseBase);
        }
        catch (UpdateException ex) {
            SPARQL_Update.errorBadRequest(ex.getMessage());
            req = null;
        }
        catch (QueryParseException ex) {
            SPARQL_Update.errorBadRequest(SPARQL_Update.messageForQPE(ex));
            req = null;
        }
        this.execute(action, req);
        SPARQL_Update.successPage(action, "Update succeeded");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void execute(HttpActionUpdate action, UpdateRequest updateRequest) {
        action.beginWrite();
        try {
            UpdateAction.execute((UpdateRequest)updateRequest, (DatasetGraph)action.getActiveDSG());
            action.commit();
        }
        catch (UpdateException ex) {
            action.abort();
            SPARQL_Update.errorBadRequest(ex.getMessage());
        }
        finally {
            action.endWrite();
        }
    }

    private class HttpActionUpdate
    extends SPARQL_Protocol.HttpActionProtocol {
        public HttpActionUpdate(long id, DatasetGraph dsg, HttpServletRequest request, HttpServletResponse response, boolean verbose) {
            super(SPARQL_Update.this, id, dsg, request, response, verbose);
        }
    }
}

