/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.fuseki.servlets;

import java.io.IOException;
import java.io.PrintWriter;
import java.util.concurrent.atomic.AtomicLong;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.jena.fuseki.Fuseki;
import org.apache.jena.fuseki.servlets.ActionErrorException;
import org.apache.jena.fuseki.servlets.HttpAction;
import org.openjena.atlas.lib.StrUtils;
import org.slf4j.Logger;

public abstract class ServletBase
extends HttpServlet {
    protected static final Logger log = Fuseki.requestLog;
    protected static AtomicLong requestIdAlloc = new AtomicLong(0L);
    protected final boolean verbose_debug;
    static String varyHeaderSetting = StrUtils.strjoin((String)",", (String[])new String[]{"Accept", "Accept-Encoding", "Accept-Charset"});

    protected ServletBase(boolean verbose_debug) {
        this.verbose_debug = verbose_debug;
    }

    private void responseSendError(HttpServletResponse response, int statusCode, String message) {
        try {
            response.sendError(statusCode, message);
        }
        catch (IOException ex) {
            ServletBase.errorOccurred(ex);
        }
    }

    private void responseSendError(HttpServletResponse response, int statusCode) {
        try {
            response.sendError(statusCode);
        }
        catch (IOException ex) {
            ServletBase.errorOccurred(ex);
        }
    }

    protected static String wholeRequestURL(HttpServletRequest request) {
        StringBuffer sb = request.getRequestURL();
        String queryString = request.getQueryString();
        if (queryString != null) {
            sb.append("?");
            sb.append(queryString);
        }
        return sb.toString();
    }

    protected static void successNoContent(HttpAction action) {
        ServletBase.success(action, 204);
    }

    protected static void success(HttpAction action) {
        ServletBase.success(action, 200);
    }

    protected static void successCreated(HttpAction action) {
        ServletBase.success(action, 201);
    }

    protected static void successNotFound(HttpAction action) {
        ServletBase.success(action, 404);
    }

    protected static void success(HttpAction action, int httpStatusCode) {
        action.response.setStatus(httpStatusCode);
    }

    protected static void successPage(HttpAction action, String message) {
        try {
            action.response.setContentType("text/html");
            action.response.setStatus(200);
            PrintWriter out = action.response.getWriter();
            out.println("<html>");
            out.println("<head>");
            out.println("</head>");
            out.println("<body>");
            out.println("<h1>Success</h1>");
            if (message != null) {
                out.println("<p>");
                out.println(message);
                out.println("</p>");
            }
            out.println("</body>");
            out.println("</html>");
            out.flush();
        }
        catch (IOException ex) {
            ServletBase.errorOccurred(ex);
        }
    }

    protected static void warning(String string) {
        log.warn(string);
    }

    protected static void warning(String string, Throwable thorwable) {
        log.warn(string, thorwable);
    }

    protected static void errorBadRequest(String string) {
        ServletBase.error(400, string);
    }

    protected static void errorNotFound(String string) {
        ServletBase.error(404, string);
    }

    protected static void errorNotImplemented(String msg) {
        ServletBase.error(501, msg);
    }

    protected static void errorMethodNotAllowed(String method) {
        ServletBase.error(405, "HTTP method not allowed: " + method);
    }

    protected static void error(int statusCode) {
        throw new ActionErrorException(null, null, statusCode);
    }

    protected static void error(int statusCode, String string) {
        throw new ActionErrorException(null, string, statusCode);
    }

    protected static void errorOccurred(String message) {
        ServletBase.errorOccurred(message, null);
    }

    protected static void errorOccurred(Throwable ex) {
        ServletBase.errorOccurred(null, ex);
    }

    protected static void errorOccurred(String message, Throwable ex) {
        throw new ActionErrorException(ex, message, 500);
    }

    protected static String formatForLog(String string) {
        string = string.replace('\n', ' ');
        string = string.replace('\r', ' ');
        return string;
    }

    public static void setVaryHeader(HttpServletResponse httpResponse) {
        httpResponse.setHeader("Vary", varyHeaderSetting);
    }

    public static void setCommonHeaders(HttpServletResponse httpResponse) {
        httpResponse.setHeader("Access-Control-Allow-Origin", "*");
        httpResponse.setHeader("Server", Fuseki.serverHttpName);
    }
}

