/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.fuseki;

import com.hp.hpl.jena.graph.Graph;
import com.hp.hpl.jena.graph.Node;
import com.hp.hpl.jena.graph.Triple;
import com.hp.hpl.jena.shared.PrefixMapping;
import com.hp.hpl.jena.sparql.core.DatasetGraph;
import com.hp.hpl.jena.sparql.core.Quad;
import com.hp.hpl.jena.sparql.util.Convert;
import com.hp.hpl.jena.util.iterator.ExtendedIterator;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang.StringUtils;
import org.apache.jena.atlas.lib.MultiMap;
import org.apache.jena.atlas.lib.MultiMapToList;
import org.apache.jena.atlas.web.ContentType;
import org.apache.jena.fuseki.servlets.HttpAction;
import org.apache.jena.riot.Lang;
import org.apache.jena.riot.RDFLanguages;

public class FusekiLib {
    public static ContentType getContentType(HttpAction action) {
        return FusekiLib.getContentType(action.request);
    }

    public static ContentType getContentType(HttpServletRequest request) {
        String contentTypeHeader = request.getContentType();
        if (contentTypeHeader == null) {
            return null;
        }
        return ContentType.create((String)contentTypeHeader);
    }

    public static Lang getLangFromAction(HttpAction action, Lang dft) {
        String contentTypeHeader = action.request.getContentType();
        if (contentTypeHeader == null) {
            return dft;
        }
        return RDFLanguages.contentTypeToLang((String)contentTypeHeader);
    }

    static String fmtRequest(HttpServletRequest request) {
        StringBuilder sbuff = new StringBuilder();
        sbuff.append(request.getMethod());
        sbuff.append(" ");
        sbuff.append(Convert.decWWWForm((StringBuffer)request.getRequestURL()));
        String qs = request.getQueryString();
        if (qs != null) {
            String tmp = request.getQueryString();
            tmp = Convert.decWWWForm((String)tmp);
            tmp = tmp.replace('\n', ' ');
            tmp = tmp.replace('\r', ' ');
            sbuff.append("?").append(tmp);
        }
        return sbuff.toString();
    }

    public static MultiMap<String, String> parseQueryString(HttpServletRequest req) {
        MultiMapToList map = MultiMapToList.create();
        if (req.getQueryString() != null) {
            String[] params;
            for (String p : params = req.getQueryString().split("&")) {
                String[] x = p.split("=", 2);
                String name = null;
                String value = null;
                if (x.length == 0) {
                    name = p;
                    value = "";
                } else if (x.length == 1) {
                    name = x[0];
                    value = "";
                } else {
                    name = x[0];
                    value = x[1];
                }
                map.put((Object)name, (Object)value);
            }
        }
        return map;
    }

    public static String safeParameter(HttpServletRequest request, String pName) {
        String value = request.getParameter(pName);
        value = StringUtils.replaceChars((String)value, (String)"\r", (String)"");
        value = StringUtils.replaceChars((String)value, (String)"\n", (String)"");
        return value;
    }

    public static void addDataInto(Graph data, DatasetGraph dsg, Node graphName) {
        if (graphName == null) {
            graphName = Quad.defaultGraphNodeGenerated;
        }
        ExtendedIterator iter = data.find(Node.ANY, Node.ANY, Node.ANY);
        while (iter.hasNext()) {
            Triple t = (Triple)iter.next();
            dsg.add(graphName, t.getSubject(), t.getPredicate(), t.getObject());
        }
        PrefixMapping pmapSrc = data.getPrefixMapping();
        PrefixMapping pmapDest = dsg.getDefaultGraph().getPrefixMapping();
        pmapDest.setNsPrefixes(pmapSrc);
    }
}

