/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.fuseki.server;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.apache.jena.fuseki.server.Counter;
import org.apache.jena.fuseki.server.CounterName;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CounterSet {
    private static Logger log = LoggerFactory.getLogger(CounterSet.class);
    private Map<CounterName, Counter> counters = new HashMap<CounterName, Counter>();

    public Collection<CounterName> counters() {
        return this.counters.keySet();
    }

    public void inc(CounterName c) {
        this.get(c).inc();
    }

    public void dec(CounterName c) {
        this.get(c).dec();
    }

    public long value(CounterName c) {
        return this.get(c).value();
    }

    public void add(CounterName counterName) {
        if (this.counters.containsKey((Object)counterName)) {
            log.warn("Duplicate counter in counter set: " + (Object)((Object)counterName));
            return;
        }
        this.counters.put(counterName, new Counter());
    }

    public boolean contains(CounterName cn) {
        return this.counters.containsKey((Object)cn);
    }

    public Counter get(CounterName cn) {
        Counter c = this.counters.get((Object)cn);
        if (c == null) {
            log.warn("No counter in counter set: " + (Object)((Object)cn));
        }
        return c;
    }
}

