/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.fuseki.server;

import com.hp.hpl.jena.query.ReadWrite;
import com.hp.hpl.jena.sparql.core.DatasetGraph;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.jena.fuseki.Fuseki;
import org.apache.jena.fuseki.server.CounterName;
import org.apache.jena.fuseki.server.CounterSet;
import org.apache.jena.fuseki.server.Counters;
import org.apache.jena.fuseki.server.DatasetMXBean;
import org.apache.jena.fuseki.server.ServiceRef;

public class DatasetRef
implements DatasetMXBean,
Counters {
    public String name = null;
    public DatasetGraph dataset = null;
    public ServiceRef query = new ServiceRef("query");
    public ServiceRef update = new ServiceRef("update");
    public ServiceRef upload = new ServiceRef("upload");
    public ServiceRef readGraphStore = new ServiceRef("gspRead");
    public ServiceRef readWriteGraphStore = new ServiceRef("gspReadWrite");
    private final CounterSet counters = new CounterSet();
    private Map<String, ServiceRef> endpoints = new HashMap<String, ServiceRef>();
    private List<ServiceRef> serviceRefs = new ArrayList<ServiceRef>();
    private boolean initialized = false;
    public AtomicLong activeReadTxn = new AtomicLong(0L);
    public AtomicLong activeWriteTxn = new AtomicLong(0L);
    public AtomicLong totalReadTxn = new AtomicLong(0L);
    public AtomicLong totalWriteTxn = new AtomicLong(0L);
    public boolean allowDatasetUpdate = false;
    public boolean allowTimeoutOverride = false;
    public long maximumTimeoutOverride = Long.MAX_VALUE;

    @Override
    public CounterSet getCounters() {
        return this.counters;
    }

    public void init() {
        if (this.initialized) {
            Fuseki.serverLog.warn("Already initialized: dataset = " + this.name);
        }
        this.initialized = true;
        this.initServices();
    }

    public String toString() {
        return "DatasetRef:'" + this.name + "'";
    }

    private void initServices() {
        this.add(this.query);
        this.add(this.update);
        this.add(this.upload);
        this.add(this.readGraphStore);
        this.add(this.readWriteGraphStore);
        this.addCounters();
    }

    private void add(ServiceRef srvRef) {
        this.serviceRefs.add(srvRef);
        for (String ep : srvRef.endpoints) {
            this.endpoints.put(ep, srvRef);
        }
    }

    public ServiceRef getServiceRef(String service) {
        if (!this.initialized) {
            Fuseki.serverLog.error("Not initialized: dataset = " + this.name);
        }
        if (service.startsWith("/")) {
            service = service.substring(1, service.length());
        }
        return this.endpoints.get(service);
    }

    public Collection<ServiceRef> getServiceRefs() {
        return this.serviceRefs;
    }

    public void startTxn(ReadWrite mode) {
        switch (mode) {
            case READ: {
                this.activeReadTxn.getAndIncrement();
                this.totalReadTxn.getAndIncrement();
                break;
            }
            case WRITE: {
                this.activeWriteTxn.getAndIncrement();
                this.totalWriteTxn.getAndIncrement();
            }
        }
    }

    public void finishTxn(ReadWrite mode) {
        switch (mode) {
            case READ: {
                this.activeReadTxn.decrementAndGet();
                break;
            }
            case WRITE: {
                this.activeWriteTxn.decrementAndGet();
            }
        }
    }

    public boolean isReadOnly() {
        return !this.allowDatasetUpdate && !this.update.isActive() && !this.upload.isActive() && !this.readWriteGraphStore.isActive();
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public long getRequests() {
        return this.counters.value(CounterName.Requests);
    }

    @Override
    public long getRequestsGood() {
        return this.counters.value(CounterName.RequestsGood);
    }

    @Override
    public long getRequestsBad() {
        return this.counters.value(CounterName.RequestsBad);
    }

    private void addCounters() {
        this.getCounters().add(CounterName.Requests);
        this.getCounters().add(CounterName.RequestsGood);
        this.getCounters().add(CounterName.RequestsBad);
        this.query.getCounters().add(CounterName.Requests);
        this.query.getCounters().add(CounterName.RequestsGood);
        this.query.getCounters().add(CounterName.RequestsBad);
        this.query.getCounters().add(CounterName.QueryTimeouts);
        this.query.getCounters().add(CounterName.QueryExecErrors);
        this.update.getCounters().add(CounterName.Requests);
        this.update.getCounters().add(CounterName.RequestsGood);
        this.update.getCounters().add(CounterName.RequestsBad);
        this.update.getCounters().add(CounterName.UpdateExecErrors);
        this.upload.getCounters().add(CounterName.Requests);
        this.upload.getCounters().add(CounterName.RequestsGood);
        this.upload.getCounters().add(CounterName.RequestsBad);
        this.addCountersForGSP(this.readWriteGraphStore.getCounters(), false);
        if (this.readGraphStore != this.readWriteGraphStore) {
            this.addCountersForGSP(this.readGraphStore.getCounters(), true);
        }
    }

    private void addCountersForGSP(CounterSet cs, boolean readWrite) {
        cs.add(CounterName.Requests);
        cs.add(CounterName.RequestsGood);
        cs.add(CounterName.RequestsBad);
        cs.add(CounterName.GSPget);
        cs.add(CounterName.GSPgetGood);
        cs.add(CounterName.GSPgetBad);
        cs.add(CounterName.GSPhead);
        cs.add(CounterName.GSPheadGood);
        cs.add(CounterName.GSPheadBad);
        cs.add(CounterName.GSPput);
        cs.add(CounterName.GSPputGood);
        cs.add(CounterName.GSPputBad);
        cs.add(CounterName.GSPpost);
        cs.add(CounterName.GSPpostGood);
        cs.add(CounterName.GSPpostBad);
        cs.add(CounterName.GSPdelete);
        cs.add(CounterName.GSPdeleteGood);
        cs.add(CounterName.GSPdeleteBad);
        cs.add(CounterName.GSPpatch);
        cs.add(CounterName.GSPpatchGood);
        cs.add(CounterName.GSPpatchBad);
        cs.add(CounterName.GSPoptions);
        cs.add(CounterName.GSPoptionsGood);
        cs.add(CounterName.GSPoptionsBad);
    }
}

