/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.fuseki.server;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.Writer;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.jena.fuseki.Fuseki;
import org.apache.jena.web.HttpSC;
import org.eclipse.jetty.server.AbstractHttpConnection;
import org.eclipse.jetty.server.Request;
import org.eclipse.jetty.server.handler.ErrorHandler;

public class FusekiErrorHandler
extends ErrorHandler {
    public void handle(String target, Request baseRequest, HttpServletRequest request, HttpServletResponse response) throws IOException {
        AbstractHttpConnection connection = AbstractHttpConnection.getCurrentConnection();
        connection.getRequest().setHandled(true);
        String method = request.getMethod();
        if (!(method.equals("GET") || method.equals("POST") || method.equals("HEAD"))) {
            return;
        }
        response.setContentType("text/plain;charset=UTF-8");
        response.setHeader("Cache-Control", "must-revalidate,no-cache,no-store");
        ByteArrayOutputStream bytes = new ByteArrayOutputStream(1024);
        try (OutputStreamWriter writer = new OutputStreamWriter((OutputStream)bytes, "UTF-8");){
            this.handleErrorPage(request, writer, connection.getResponse().getStatus(), connection.getResponse().getReason());
            if (!Fuseki.VERSION.equalsIgnoreCase("development")) {
                writer.write("\n");
                writer.write("\n");
                writer.write(String.format("Fuseki - version %s (Build date: %s)\n", Fuseki.VERSION, Fuseki.BUILD_DATE));
            }
            ((Writer)writer).flush();
        }
        response.setContentLength(bytes.size());
        response.getOutputStream().write(bytes.toByteArray());
    }

    protected void handleErrorPage(HttpServletRequest request, Writer writer, int code, String message) throws IOException {
        if (message == null) {
            message = HttpSC.getMessage((int)code);
        }
        writer.write(String.format("Error %d: %s\n", code, message));
        for (Throwable th = (Throwable)request.getAttribute("javax.servlet.error.exception"); th != null; th = th.getCause()) {
            writer.write("\n");
            StringWriter sw = new StringWriter();
            PrintWriter pw = new PrintWriter(sw);
            th.printStackTrace(pw);
            pw.flush();
            writer.write(sw.getBuffer().toString());
            writer.write("\n");
        }
    }
}

