/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.fuseki.servlets;

import com.hp.hpl.jena.query.ReadWrite;
import com.hp.hpl.jena.sparql.SystemARQ;
import com.hp.hpl.jena.sparql.core.DatasetGraph;
import com.hp.hpl.jena.sparql.core.DatasetGraphWithLock;
import com.hp.hpl.jena.sparql.core.DatasetGraphWrapper;
import com.hp.hpl.jena.sparql.core.Transactional;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.jena.atlas.logging.Log;
import org.apache.jena.atlas.web.MediaType;
import org.apache.jena.fuseki.DEF;
import org.apache.jena.fuseki.conneg.ConNeg;
import org.apache.jena.fuseki.server.DatasetRef;
import org.apache.jena.fuseki.server.ServiceRef;
import org.apache.jena.fuseki.servlets.HttpServletResponseTracker;

public class HttpAction {
    public final long id;
    public final boolean verbose;
    private DatasetGraph dsg;
    public DatasetRef dsRef;
    public ServiceRef srvRef;
    private Transactional transactional;
    private boolean isTransactional;
    private DatasetGraph activeDSG;
    private ReadWrite activeMode;
    private boolean startTimeIsSet = false;
    private boolean finishTimeIsSet = false;
    private long startTime = -2L;
    private long finishTime = -2L;
    int statusCode = -1;
    String message = null;
    int contentLength = -1;
    String contentType = null;
    Map<String, String> headers = new HashMap<String, String>();
    public HttpServletRequest request;
    public HttpServletResponseTracker response;

    public HttpAction(long id, HttpServletRequest request, HttpServletResponse response, boolean verbose) {
        this.id = id;
        this.request = request;
        this.response = new HttpServletResponseTracker(this, response);
        this.verbose = verbose;
    }

    public void setDataset(DatasetRef desc) {
        this.dsRef = desc;
        this.dsg = desc.dataset;
        DatasetGraph basedsg = HttpAction.unwrap(this.dsg);
        if (HttpAction.isTransactional(basedsg) && HttpAction.isTransactional(this.dsg)) {
            this.transactional = (Transactional)this.dsg;
            this.isTransactional = true;
        } else {
            this.transactional = new DatasetGraphWithLock(this.dsg);
            this.isTransactional = false;
        }
    }

    private static boolean isTransactional(DatasetGraph dsg) {
        return dsg instanceof Transactional;
    }

    private static DatasetGraph unwrap(DatasetGraph dsg) {
        while (dsg instanceof DatasetGraphWrapper) {
            dsg = ((DatasetGraphWrapper)dsg).getWrapped();
        }
        return dsg;
    }

    public void setService(ServiceRef srvRef) {
        this.srvRef = srvRef;
    }

    public boolean isTransactional() {
        return this.isTransactional;
    }

    public void beginRead() {
        this.activeMode = ReadWrite.READ;
        this.transactional.begin(ReadWrite.READ);
        this.activeDSG = this.dsg;
        this.dsRef.startTxn(ReadWrite.READ);
    }

    public void endRead() {
        this.dsRef.finishTxn(ReadWrite.READ);
        this.activeMode = null;
        this.transactional.end();
        this.activeDSG = null;
    }

    public void beginWrite() {
        this.transactional.begin(ReadWrite.WRITE);
        this.activeMode = ReadWrite.WRITE;
        this.activeDSG = this.dsg;
        this.dsRef.startTxn(ReadWrite.WRITE);
    }

    public void commit() {
        this.transactional.commit();
        this.activeDSG = null;
    }

    public void abort() {
        try {
            this.transactional.abort();
        }
        catch (Exception ex) {
            Log.warn((Object)this, (String)("Exception during abort (operation attempts to continue): " + ex.getMessage()));
        }
        this.activeDSG = null;
    }

    public void endWrite() {
        this.dsRef.finishTxn(ReadWrite.WRITE);
        this.activeMode = null;
        if (this.transactional.isInTransaction()) {
            Log.warn((Object)this, (String)"Transaction still active in endWriter - no commit or abort seen (forced abort)");
            try {
                this.transactional.abort();
            }
            catch (RuntimeException ex) {
                Log.warn((Object)this, (String)"Exception in forced abort (trying to continue)", (Throwable)ex);
            }
        }
        this.transactional.end();
        this.activeDSG = null;
    }

    public final DatasetGraph getActiveDSG() {
        return this.activeDSG;
    }

    public final DatasetRef getDatasetRef() {
        return this.dsRef;
    }

    public void minimize() {
        this.request = null;
        this.response = null;
    }

    public void setStartTime() {
        if (this.startTimeIsSet) {
            Log.warn((Object)this, (String)"Start time reset");
        }
        this.startTimeIsSet = true;
        this.startTime = System.nanoTime();
    }

    public void setFinishTime() {
        if (this.finishTimeIsSet) {
            Log.warn((Object)this, (String)"Finish time reset");
        }
        this.finishTimeIsSet = true;
        this.finishTime = System.nanoTime();
    }

    public HttpServletRequest getRequest() {
        return this.request;
    }

    public HttpServletResponseTracker getResponse() {
        return this.response;
    }

    public long getTime() {
        if (!this.startTimeIsSet) {
            Log.warn((Object)this, (String)"Start time not set");
        }
        if (!this.finishTimeIsSet) {
            Log.warn((Object)this, (String)"Finish time not set");
        }
        return (this.finishTime - this.startTime) / 1000000L;
    }

    public void sync() {
        SystemARQ.sync((DatasetGraph)this.dsg);
    }

    public static MediaType contentNegotationRDF(HttpAction action) {
        MediaType mt = ConNeg.chooseContentType(action.request, DEF.rdfOffer, DEF.acceptRDFXML);
        if (mt == null) {
            return null;
        }
        if (mt.getContentType() != null) {
            action.response.setContentType(mt.getContentType());
        }
        if (mt.getCharset() != null) {
            action.response.setCharacterEncoding(mt.getCharset());
        }
        return mt;
    }

    public static MediaType contentNegotationQuads(HttpAction action) {
        return ConNeg.chooseContentType(action.request, DEF.quadsOffer, DEF.acceptNQuads);
    }
}

