/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.fuseki.servlets;

import com.hp.hpl.jena.graph.Graph;
import com.hp.hpl.jena.graph.Node;
import com.hp.hpl.jena.graph.NodeFactory;
import com.hp.hpl.jena.sparql.core.DatasetGraph;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import javax.servlet.ServletOutputStream;
import org.apache.jena.atlas.web.MediaType;
import org.apache.jena.atlas.web.TypedOutputStream;
import org.apache.jena.fuseki.Fuseki;
import org.apache.jena.fuseki.servlets.HttpAction;
import org.apache.jena.fuseki.servlets.SPARQL_REST;
import org.apache.jena.riot.Lang;
import org.apache.jena.riot.RDFDataMgr;
import org.apache.jena.riot.RDFLanguages;
import org.apache.jena.riot.ReaderRIOT;
import org.apache.jena.riot.system.StreamRDF;
import org.apache.jena.riot.system.StreamRDFLib;

public class REST_Quads
extends SPARQL_REST {
    static int counter = 0;

    @Override
    protected void validate(HttpAction action) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void doGet(HttpAction action) {
        ServletOutputStream output;
        MediaType mediaType = HttpAction.contentNegotationQuads(action);
        try {
            output = action.response.getOutputStream();
        }
        catch (IOException ex) {
            REST_Quads.errorOccurred(ex);
            output = null;
        }
        TypedOutputStream out = new TypedOutputStream((OutputStream)output, mediaType);
        Lang lang = RDFLanguages.contentTypeToLang((String)mediaType.getContentType());
        if (lang == null) {
            lang = RDFLanguages.TRIG;
        }
        if (action.verbose) {
            log.info(String.format("[%d]   Get: Content-Type=%s, Charset=%s => %s", action.id, mediaType.getContentType(), mediaType.getCharset(), lang.getName()));
        }
        if (!RDFLanguages.isQuads((Lang)lang)) {
            REST_Quads.errorBadRequest("Not a quads format: " + mediaType);
        }
        action.beginRead();
        try {
            DatasetGraph dsg = action.getActiveDSG();
            RDFDataMgr.write((OutputStream)out, (DatasetGraph)dsg, (Lang)lang);
            REST_Quads.success(action);
        }
        finally {
            action.endRead();
        }
    }

    @Override
    protected void doOptions(HttpAction action) {
        action.response.setHeader("Allow", "GET, HEAD, OPTIONS");
        action.response.setHeader("Content-Length", "0");
        REST_Quads.success(action);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void doHead(HttpAction action) {
        action.beginRead();
        try {
            MediaType mediaType = HttpAction.contentNegotationQuads(action);
            REST_Quads.success(action);
        }
        finally {
            action.endRead();
        }
    }

    @Override
    protected void doPost(HttpAction action) {
        MediaType mediaType;
        Lang lang;
        if (!action.getDatasetRef().allowDatasetUpdate) {
            REST_Quads.errorMethodNotAllowed("POST");
        }
        boolean gspMode = Fuseki.graphStoreProtocolPostCreate;
        String x = action.request.getContentType();
        if (x == null) {
            REST_Quads.errorBadRequest("Content-type required for data format");
        }
        if ((lang = RDFLanguages.contentTypeToLang((String)(mediaType = MediaType.create((String)x)).getContentType())) == null) {
            lang = RDFLanguages.TRIG;
        }
        if (action.verbose) {
            log.info(String.format("[%d]   Post: Content-Type=%s, Charset=%s => %s", action.id, mediaType.getContentType(), mediaType.getCharset(), lang.getName()));
        }
        if (RDFLanguages.isQuads((Lang)lang)) {
            this.doPostQuads(action, lang);
        } else if (gspMode && RDFLanguages.isTriples((Lang)lang)) {
            this.doPostTriplesGSP(action, lang);
        } else if (RDFLanguages.isTriples((Lang)lang)) {
            this.doPostTriples(action, lang);
        } else {
            REST_Quads.errorBadRequest("Not a triples or quads format: " + mediaType);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doPostQuads(HttpAction action, Lang lang) {
        action.beginWrite();
        try {
            String name = action.request.getRequestURL().toString();
            DatasetGraph dsg = action.getActiveDSG();
            StreamRDF dest = StreamRDFLib.dataset((DatasetGraph)dsg);
            ReaderRIOT reader = RDFDataMgr.createReader((Lang)lang);
            reader.read((InputStream)action.request.getInputStream(), name, null, dest, null);
            action.commit();
            REST_Quads.success(action);
        }
        catch (IOException ex) {
            action.abort();
        }
        finally {
            action.endWrite();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doPostTriples(HttpAction action, Lang lang) {
        action.beginWrite();
        try {
            DatasetGraph dsg = action.getActiveDSG();
            String name = action.request.getRequestURL().toString();
            Graph g = dsg.getDefaultGraph();
            StreamRDF dest = StreamRDFLib.graph((Graph)g);
            ReaderRIOT reader = RDFDataMgr.createReader((Lang)lang);
            reader.read((InputStream)action.request.getInputStream(), name, null, dest, null);
            action.commit();
            REST_Quads.success(action);
        }
        catch (IOException ex) {
            action.abort();
        }
        finally {
            action.endWrite();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doPostTriplesGSP(HttpAction action, Lang lang) {
        action.beginWrite();
        try {
            DatasetGraph dsg = action.getActiveDSG();
            String name = action.request.getRequestURL().toString();
            if (!name.endsWith("/")) {
                name = name + "/";
            }
            name = name + ++counter;
            Node gn = NodeFactory.createURI((String)name);
            Graph g = dsg.getGraph(gn);
            StreamRDF dest = StreamRDFLib.graph((Graph)g);
            ReaderRIOT reader = RDFDataMgr.createReader((Lang)lang);
            reader.read((InputStream)action.request.getInputStream(), name, null, dest, null);
            log.info(String.format("[%d] Location: %s", action.id, name));
            action.response.setHeader("Location", name);
            action.commit();
            REST_Quads.successCreated(action);
        }
        catch (IOException ex) {
            action.abort();
        }
        finally {
            action.endWrite();
        }
    }

    @Override
    protected void doDelete(HttpAction action) {
        REST_Quads.errorMethodNotAllowed("DELETE");
    }

    @Override
    protected void doPut(HttpAction action) {
        REST_Quads.errorMethodNotAllowed("PUT");
    }

    @Override
    protected void doPatch(HttpAction action) {
        REST_Quads.errorMethodNotAllowed("PATCH");
    }
}

