/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.fuseki.servlets;

import com.hp.hpl.jena.graph.Graph;
import com.hp.hpl.jena.graph.Node;
import com.hp.hpl.jena.graph.NodeFactory;
import com.hp.hpl.jena.sparql.core.DatasetGraph;
import java.io.IOException;
import java.io.InputStream;
import java.util.Enumeration;
import java.util.Locale;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.jena.fuseki.server.CounterName;
import org.apache.jena.fuseki.servlets.ActionErrorException;
import org.apache.jena.fuseki.servlets.HttpAction;
import org.apache.jena.fuseki.servlets.HttpServletResponseTracker;
import org.apache.jena.fuseki.servlets.SPARQL_Protocol;
import org.apache.jena.fuseki.servlets.SPARQL_ServletBase;
import org.apache.jena.riot.Lang;
import org.apache.jena.riot.RDFDataMgr;
import org.apache.jena.riot.ReaderRIOT;
import org.apache.jena.riot.RiotException;
import org.apache.jena.riot.system.ErrorHandler;
import org.apache.jena.riot.system.ErrorHandlerFactory;
import org.apache.jena.riot.system.IRIResolver;
import org.apache.jena.riot.system.StreamRDF;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class SPARQL_REST
extends SPARQL_ServletBase {
    protected static Logger classLog = LoggerFactory.getLogger(SPARQL_REST.class);
    protected static ErrorHandler errorHandler = ErrorHandlerFactory.errorHandlerStd((Logger)log);

    protected static final Target determineTarget(HttpAction action) {
        if (action.getActiveDSG() == null) {
            SPARQL_REST.errorOccurred("Internal error : No action graph (not in a transaction?)");
        }
        boolean dftGraph = SPARQL_REST.getOneOnly(action.request, "default") != null;
        String uri = SPARQL_REST.getOneOnly(action.request, "graph");
        if (!dftGraph && uri == null) {
            uri = action.request.getRequestURL().toString();
            if (action.request.getRequestURI().equals(action.getDatasetRef().name)) {
                SPARQL_REST.errorBadRequest("Neither default graph nor named graph specified; no direct name");
            }
        }
        if (dftGraph) {
            return Target.createDefault(action.getActiveDSG());
        }
        if (uri.equals("default")) {
            return Target.createDefault(action.getActiveDSG());
        }
        String base = action.request.getRequestURL().toString();
        if (action.request.getQueryString() != null && !base.endsWith("/")) {
            base = base + "/";
        }
        String absUri = IRIResolver.resolveString((String)uri, (String)base);
        Node gn = NodeFactory.createURI((String)absUri);
        return Target.createNamed(action.getActiveDSG(), absUri, gn);
    }

    protected void service(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        this.doCommon(request, response);
    }

    private void maybeSetLastModified(HttpServletResponse resp, long lastModified) {
        if (resp.containsHeader("Last-Modified")) {
            return;
        }
        if (lastModified >= 0L) {
            resp.setDateHeader("Last-Modified", lastModified);
        }
    }

    @Override
    protected void perform(HttpAction action) {
        this.dispatch(action);
    }

    private void dispatch(HttpAction action) {
        HttpServletRequest req = action.request;
        HttpServletResponseTracker resp = action.response;
        String method = req.getMethod().toUpperCase(Locale.ROOT);
        if (method.equals("GET")) {
            this.doGet$(action);
        } else if (method.equals("HEAD")) {
            this.doHead$(action);
        } else if (method.equals("POST")) {
            this.doPost$(action);
        } else if (method.equals("PATCH")) {
            this.doPatch$(action);
        } else if (method.equals("OPTIONS")) {
            this.doOptions$(action);
        } else if (method.equals("TRACE")) {
            SPARQL_REST.errorMethodNotAllowed("TRACE");
        } else if (method.equals("PUT")) {
            this.doPut$(action);
        } else if (method.equals("DELETE")) {
            this.doDelete$(action);
        } else {
            SPARQL_REST.errorNotImplemented("Unknown method: " + method);
        }
    }

    protected void doGet$(HttpAction action) {
        SPARQL_REST.incCounter(action.srvRef, CounterName.GSPget);
        try {
            this.doGet(action);
            SPARQL_REST.incCounter(action.srvRef, CounterName.GSPgetGood);
        }
        catch (ActionErrorException ex) {
            SPARQL_REST.incCounter(action.srvRef, CounterName.GSPgetBad);
            throw ex;
        }
    }

    protected void doHead$(HttpAction action) {
        SPARQL_REST.incCounter(action.srvRef, CounterName.GSPhead);
        try {
            this.doHead(action);
            SPARQL_REST.incCounter(action.srvRef, CounterName.GSPheadGood);
        }
        catch (ActionErrorException ex) {
            SPARQL_REST.incCounter(action.srvRef, CounterName.GSPheadBad);
            throw ex;
        }
    }

    protected void doPost$(HttpAction action) {
        SPARQL_REST.incCounter(action.srvRef, CounterName.GSPpost);
        try {
            this.doPost(action);
            SPARQL_REST.incCounter(action.srvRef, CounterName.GSPpostGood);
        }
        catch (ActionErrorException ex) {
            SPARQL_REST.incCounter(action.srvRef, CounterName.GSPpostBad);
            throw ex;
        }
    }

    protected void doPatch$(HttpAction action) {
        SPARQL_REST.incCounter(action.srvRef, CounterName.GSPpatch);
        try {
            this.doPatch(action);
            SPARQL_REST.incCounter(action.srvRef, CounterName.GSPpatchGood);
        }
        catch (ActionErrorException ex) {
            SPARQL_REST.incCounter(action.srvRef, CounterName.GSPpatchBad);
            throw ex;
        }
    }

    protected void doDelete$(HttpAction action) {
        SPARQL_REST.incCounter(action.srvRef, CounterName.GSPdelete);
        try {
            this.doDelete(action);
            SPARQL_REST.incCounter(action.srvRef, CounterName.GSPdeleteGood);
        }
        catch (ActionErrorException ex) {
            SPARQL_REST.incCounter(action.srvRef, CounterName.GSPdeleteBad);
            throw ex;
        }
    }

    protected void doPut$(HttpAction action) {
        SPARQL_REST.incCounter(action.srvRef, CounterName.GSPput);
        try {
            this.doPut(action);
            SPARQL_REST.incCounter(action.srvRef, CounterName.GSPputGood);
        }
        catch (ActionErrorException ex) {
            SPARQL_REST.incCounter(action.srvRef, CounterName.GSPputBad);
            throw ex;
        }
    }

    protected void doOptions$(HttpAction action) {
        SPARQL_REST.incCounter(action.srvRef, CounterName.GSPoptions);
        try {
            this.doOptions(action);
            SPARQL_REST.incCounter(action.srvRef, CounterName.GSPoptionsGood);
        }
        catch (ActionErrorException ex) {
            SPARQL_REST.incCounter(action.srvRef, CounterName.GSPoptionsBad);
            throw ex;
        }
    }

    protected abstract void doGet(HttpAction var1);

    protected abstract void doHead(HttpAction var1);

    protected abstract void doPost(HttpAction var1);

    protected abstract void doPatch(HttpAction var1);

    protected abstract void doDelete(HttpAction var1);

    protected abstract void doPut(HttpAction var1);

    protected abstract void doOptions(HttpAction var1);

    public static void parse(HttpAction action, StreamRDF dest, InputStream input, Lang lang, String base) {
        try {
            ReaderRIOT r = RDFDataMgr.createReader((Lang)lang);
            if (r == null) {
                SPARQL_REST.errorBadRequest("No parser for language '" + lang.getName() + "'");
            }
            r.setErrorHandler(errorHandler);
            r.read(input, base, null, dest, null);
        }
        catch (RiotException ex) {
            SPARQL_REST.errorBadRequest("Parse error: " + ex.getMessage());
        }
    }

    @Override
    protected void validate(HttpAction action) {
        HttpServletRequest request = action.request;
        if (request.getQueryString() == null) {
            return;
        }
        String g = request.getParameter("graph");
        String d = request.getParameter("default");
        if (g != null && d != null) {
            SPARQL_REST.errorBadRequest("Both ?default and ?graph in the query string of the request");
        }
        if (g == null && d == null) {
            SPARQL_REST.errorBadRequest("Neither ?default nor ?graph in the query string of the request");
        }
        int x1 = SPARQL_Protocol.countParamOccurences(request, "graph");
        int x2 = SPARQL_Protocol.countParamOccurences(request, "default");
        if (x1 > 1) {
            SPARQL_REST.errorBadRequest("Multiple ?default in the query string of the request");
        }
        if (x2 > 1) {
            SPARQL_REST.errorBadRequest("Multiple ?graph in the query string of the request");
        }
        Enumeration en = request.getParameterNames();
        while (en.hasMoreElements()) {
            String h = (String)en.nextElement();
            if (!"graph".equals(h) && !"default".equals(h)) {
                SPARQL_REST.errorBadRequest("Unknown parameter '" + h + "'");
            }
            if (request.getParameterValues(h).length == 1) continue;
            SPARQL_REST.errorBadRequest("Multiple parameters '" + h + "'");
        }
    }

    protected static String getOneOnly(HttpServletRequest request, String name) {
        String[] values = request.getParameterValues(name);
        if (values == null) {
            return null;
        }
        if (values.length == 0) {
            return null;
        }
        if (values.length > 1) {
            SPARQL_REST.errorBadRequest("Multiple occurrences of '" + name + "'");
        }
        return values[0];
    }

    protected static final class Target {
        final boolean isDefault;
        final DatasetGraph dsg;
        private Graph _graph;
        final String name;
        final Node graphName;

        static Target createNamed(DatasetGraph dsg, String name, Node graphName) {
            return new Target(false, dsg, name, graphName);
        }

        static Target createDefault(DatasetGraph dsg) {
            return new Target(true, dsg, null, null);
        }

        private Target(boolean isDefault, DatasetGraph dsg, String name, Node graphName) {
            this.isDefault = isDefault;
            this.dsg = dsg;
            this._graph = null;
            this.name = name;
            this.graphName = graphName;
            if (isDefault) {
                if (name != null || graphName != null) {
                    throw new IllegalArgumentException("Inconsistent: default and a graph name/node");
                }
            } else if (name == null || graphName == null) {
                throw new IllegalArgumentException("Inconsistent: not default and/or no graph name/node");
            }
        }

        public Graph graph() {
            if (!this.isGraphSet()) {
                this._graph = this.isDefault ? this.dsg.getDefaultGraph() : this.dsg.getGraph(this.graphName);
            }
            return this._graph;
        }

        public boolean exists() {
            if (this.isDefault) {
                return true;
            }
            return this.dsg.containsGraph(this.graphName);
        }

        public boolean isGraphSet() {
            return this._graph != null;
        }

        public String toString() {
            if (this.isDefault) {
                return "default";
            }
            return this.name;
        }
    }
}

