/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.fuseki.servlets;

import com.hp.hpl.jena.graph.Graph;
import com.hp.hpl.jena.sparql.graph.GraphFactory;
import java.io.IOException;
import java.io.InputStream;
import java.util.Map;
import javax.servlet.ServletInputStream;
import org.apache.jena.atlas.io.IO;
import org.apache.jena.atlas.web.ContentType;
import org.apache.jena.fuseki.FusekiLib;
import org.apache.jena.fuseki.servlets.HttpAction;
import org.apache.jena.fuseki.servlets.SPARQL_REST;
import org.apache.jena.fuseki.servlets.SPARQL_REST_R;
import org.apache.jena.fuseki.servlets.SPARQL_Upload;
import org.apache.jena.fuseki.servlets.ServletBase;
import org.apache.jena.riot.Lang;
import org.apache.jena.riot.RDFLanguages;
import org.apache.jena.riot.RiotException;
import org.apache.jena.riot.WebContent;
import org.apache.jena.riot.system.StreamRDF;
import org.apache.jena.riot.system.StreamRDFLib;

public class SPARQL_REST_RW
extends SPARQL_REST_R {
    @Override
    protected void doOptions(HttpAction action) {
        action.response.setHeader("Allow", "GET,HEAD,OPTIONS,PUT,DELETE,POST");
        action.response.setHeader("Content-Length", "0");
        SPARQL_REST_RW.success(action);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void doDelete(HttpAction action) {
        action.beginWrite();
        try {
            boolean existedBefore;
            SPARQL_REST.Target target = SPARQL_REST_RW.determineTarget(action);
            if (log.isDebugEnabled()) {
                log.debug("DELETE->" + target);
            }
            if (!(existedBefore = target.exists())) {
                action.commit();
                SPARQL_REST_RW.errorNotFound("No such graph: " + target.name);
            }
            SPARQL_REST_RW.deleteGraph(action);
            action.commit();
        }
        finally {
            action.endWrite();
        }
        ServletBase.successNoContent(action);
    }

    @Override
    protected void doPut(HttpAction action) {
        this.doPutPost(action, true);
    }

    @Override
    protected void doPost(HttpAction action) {
        this.doPutPost(action, false);
    }

    private void doPutPost(HttpAction action, boolean overwrite) {
        ContentType ct = FusekiLib.getContentType(action);
        if (ct == null) {
            SPARQL_REST_RW.errorBadRequest("No Content-Type:");
        }
        if ("multipart/form-data".equalsIgnoreCase(ct.getContentType())) {
            String base = SPARQL_REST_RW.wholeRequestURL(action.request);
            SPARQL_Upload.upload(action, base);
            return;
        }
        if (WebContent.matchContentType((ContentType)WebContent.ctMultipartMixed, (ContentType)ct)) {
            SPARQL_REST_RW.error(415, "multipart/mixed not supported");
        }
        boolean existedBefore = false;
        existedBefore = action.isTransactional() ? SPARQL_REST_RW.addDataIntoTxn(action, overwrite) : SPARQL_REST_RW.addDataIntoNonTxn(action, overwrite);
        if (existedBefore) {
            ServletBase.successNoContent(action);
        } else {
            ServletBase.successCreated(action);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static boolean addDataIntoTxn(HttpAction action, boolean overwrite) {
        action.beginWrite();
        SPARQL_REST.Target target = SPARQL_REST_RW.determineTarget(action);
        boolean existedBefore = false;
        try {
            if (log.isDebugEnabled()) {
                log.debug("  ->" + target);
            }
            existedBefore = target.exists();
            Graph g = target.graph();
            if (overwrite && existedBefore) {
                SPARQL_REST_RW.clearGraph(target);
            }
            StreamRDF sink = StreamRDFLib.graph((Graph)g);
            SPARQL_REST_RW.incomingData(action, sink);
            action.commit();
            boolean bl = existedBefore;
            return bl;
        }
        catch (RiotException ex) {
            action.abort();
            SPARQL_REST_RW.errorBadRequest(ex.getMessage());
            boolean bl = existedBefore;
            return bl;
        }
        catch (Exception ex) {
            action.abort();
            SPARQL_REST_RW.errorOccurred(ex.getMessage());
            boolean bl = existedBefore;
            return bl;
        }
        finally {
            action.endWrite();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static boolean addDataIntoNonTxn(HttpAction action, boolean overwrite) {
        Graph graphTmp = GraphFactory.createGraphMem();
        StreamRDF dest = StreamRDFLib.graph((Graph)graphTmp);
        try {
            SPARQL_REST_RW.incomingData(action, dest);
        }
        catch (RiotException ex) {
            SPARQL_REST_RW.errorBadRequest(ex.getMessage());
            return false;
        }
        action.beginWrite();
        SPARQL_REST.Target target = SPARQL_REST_RW.determineTarget(action);
        boolean existedBefore = false;
        try {
            if (log.isDebugEnabled()) {
                log.debug("  ->" + target);
            }
            existedBefore = target.exists();
            if (overwrite && existedBefore) {
                SPARQL_REST_RW.clearGraph(target);
            }
            FusekiLib.addDataInto(graphTmp, target.dsg, target.graphName);
            action.commit();
            boolean bl = existedBefore;
            return bl;
        }
        catch (Exception ex) {
            try {
                action.abort();
            }
            catch (Exception ex2) {
                // empty catch block
            }
            SPARQL_REST_RW.errorOccurred(ex.getMessage());
            boolean bl = existedBefore;
            return bl;
        }
        finally {
            action.endWrite();
        }
    }

    private static void incomingData(HttpAction action, StreamRDF dest) {
        String base = SPARQL_REST_RW.wholeRequestURL(action.request);
        ContentType ct = FusekiLib.getContentType(action);
        Lang lang = RDFLanguages.contentTypeToLang((String)ct.getContentType());
        if (lang == null) {
            SPARQL_REST_RW.errorBadRequest("Unknown content type for triples: " + ct);
            return;
        }
        ServletInputStream input = null;
        try {
            input = action.request.getInputStream();
        }
        catch (IOException ex) {
            IO.exception((IOException)ex);
        }
        int len = action.request.getContentLength();
        if (action.verbose) {
            if (len >= 0) {
                log.info(String.format("[%d]   Body: Content-Length=%d, Content-Type=%s, Charset=%s => %s", action.id, len, ct.getContentType(), ct.getCharset(), lang.getName()));
            } else {
                log.info(String.format("[%d]   Body: Content-Type=%s, Charset=%s => %s", action.id, ct.getContentType(), ct.getCharset(), lang.getName()));
            }
        }
        SPARQL_REST_RW.parse(action, dest, (InputStream)input, lang, base);
    }

    protected static void deleteGraph(HttpAction action) {
        SPARQL_REST.Target target = SPARQL_REST_RW.determineTarget(action);
        if (target.isDefault) {
            target.graph().clear();
        } else {
            action.getActiveDSG().removeGraph(target.graphName);
        }
    }

    protected static void clearGraph(SPARQL_REST.Target target) {
        Graph g = target.graph();
        g.clear();
        Map pm = g.getPrefixMapping().getNsPrefixMap();
        for (Map.Entry e : pm.entrySet()) {
            g.getPrefixMapping().removeNsPrefix((String)e.getKey());
        }
    }
}

