/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.fuseki.servlets;

import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.jena.atlas.web.MediaType;
import org.apache.jena.fuseki.DEF;
import org.apache.jena.fuseki.FusekiException;
import org.apache.jena.fuseki.conneg.ConNeg;
import org.apache.jena.fuseki.server.DatasetRef;
import org.apache.jena.fuseki.server.ServiceRef;
import org.apache.jena.fuseki.servlets.HttpAction;
import org.apache.jena.fuseki.servlets.HttpServletResponseTracker;
import org.apache.jena.fuseki.servlets.REST_Quads;
import org.apache.jena.fuseki.servlets.SPARQL_QueryDataset;
import org.apache.jena.fuseki.servlets.SPARQL_REST;
import org.apache.jena.fuseki.servlets.SPARQL_REST_R;
import org.apache.jena.fuseki.servlets.SPARQL_REST_RW;
import org.apache.jena.fuseki.servlets.SPARQL_ServletBase;
import org.apache.jena.fuseki.servlets.SPARQL_Update;
import org.apache.jena.fuseki.servlets.SPARQL_Upload;

public abstract class SPARQL_UberServlet
extends SPARQL_ServletBase {
    private final SPARQL_ServletBase queryServlet = new SPARQL_QueryDataset();
    private final SPARQL_ServletBase updateServlet = new SPARQL_Update();
    private final SPARQL_ServletBase uploadServlet = new SPARQL_Upload();
    private final SPARQL_REST restServlet_RW = new SPARQL_REST_RW();
    private final SPARQL_REST restServlet_R = new SPARQL_REST_R();
    private final SPARQL_ServletBase restQuads = new REST_Quads();

    protected abstract boolean allowQuery(HttpAction var1);

    protected abstract boolean allowUpdate(HttpAction var1);

    protected abstract boolean allowREST_R(HttpAction var1);

    protected abstract boolean allowREST_W(HttpAction var1);

    protected abstract boolean allowQuadsR(HttpAction var1);

    protected abstract boolean allowQuadsW(HttpAction var1);

    private String getEPName(String dsname, List<String> endpoints) {
        if (endpoints == null || endpoints.size() == 0) {
            return null;
        }
        String x = endpoints.get(0);
        x = !dsname.endsWith("/") ? dsname + "/" + x : dsname + x;
        return x;
    }

    @Override
    protected void validate(HttpAction action) {
        throw new FusekiException("Call to SPARQL_UberServlet.validate");
    }

    @Override
    protected void perform(HttpAction action) {
        throw new FusekiException("Call to SPARQL_UberServlet.perform");
    }

    @Override
    protected String mapRequestToDataset(String uri) {
        return SPARQL_UberServlet.mapRequestToDatasetLongest$(uri);
    }

    @Override
    protected void executeAction(HttpAction action) {
        boolean hasTrailing;
        long id = action.id;
        HttpServletRequest request = action.request;
        HttpServletResponseTracker response = action.response;
        String uri = request.getRequestURI();
        String method = request.getMethod();
        DatasetRef desc = action.dsRef;
        String trailing = this.findTrailing(uri, desc.name);
        String qs = request.getQueryString();
        boolean hasParams = request.getParameterMap().size() > 0;
        boolean hasParamQuery = request.getParameter("query") != null;
        boolean hasParamUpdate = request.getParameter("update") != null || request.getParameter("request") != null;
        boolean hasParamGraph = request.getParameter("graph") != null;
        boolean hasParamGraphDefault = request.getParameter("default") != null;
        boolean isForm = "application/x-www-form-urlencoded".equalsIgnoreCase(request.getContentType());
        String ct = request.getContentType();
        String charset = request.getCharacterEncoding();
        MediaType mt = null;
        if (ct != null) {
            mt = MediaType.create((String)ct, (String)charset);
        }
        log.info(String.format("[%d] All: %s %s :: '%s' :: %s ? %s", id, method, desc.name, trailing, mt == null ? "<none>" : mt, qs == null ? "" : qs));
        boolean bl = hasTrailing = trailing.length() != 0;
        if (!hasTrailing && !hasParams) {
            this.restQuads.executeLifecycle(action);
            return;
        }
        if (!hasTrailing) {
            if (hasParamQuery || "application/sparql-query".equalsIgnoreCase(ct)) {
                if (!this.allowQuery(action)) {
                    SPARQL_UberServlet.errorForbidden("Forbidden: SPARQL query");
                }
                this.executeRequest(action, this.queryServlet, desc.query);
                return;
            }
            if (hasParamUpdate || "application/sparql-update".equalsIgnoreCase(ct)) {
                if (!this.allowQuery(action)) {
                    SPARQL_UberServlet.errorForbidden("Forbidden: SPARQL query");
                }
                this.executeRequest(action, this.updateServlet, desc.update);
                return;
            }
            if (hasParamGraph || hasParamGraphDefault) {
                this.doGraphStoreProtocol(action);
                return;
            }
            SPARQL_UberServlet.errorBadRequest("Malformed request");
            SPARQL_UberServlet.errorForbidden("Forbidden: SPARQL Graph Store Protocol : Read operation : " + method);
        }
        boolean checkForPossibleService = true;
        if (this.serviceDispatch(action, desc.query, trailing, this.queryServlet)) {
            return;
        }
        if (this.serviceDispatch(action, desc.update, trailing, this.updateServlet)) {
            return;
        }
        if (this.serviceDispatch(action, desc.upload, trailing, this.uploadServlet)) {
            return;
        }
        if (this.serviceDispatch(action, desc.readGraphStore, trailing, this.restServlet_R)) {
            return;
        }
        if (this.serviceDispatch(action, desc.readWriteGraphStore, trailing, this.restServlet_RW)) {
            return;
        }
        if (hasParams) {
            SPARQL_UberServlet.errorNotFound("Not found: dataset='" + this.printName(desc.name) + "' service='" + this.printName(trailing) + "'");
        }
        this.doGraphStoreProtocol(action);
    }

    private String printName(String x) {
        if (x.startsWith("/")) {
            return x.substring(1);
        }
        return x;
    }

    private void doGraphStoreProtocol(HttpAction action) {
        DatasetRef desc = action.dsRef;
        String method = action.request.getMethod();
        if ("GET".equalsIgnoreCase(method) || "HEAD".equalsIgnoreCase(method)) {
            if (!this.allowREST_R(action)) {
                if (desc.readGraphStore.isActive()) {
                    this.executeRequest(action, this.restServlet_R, desc.readGraphStore);
                } else if (desc.readWriteGraphStore.isActive()) {
                    this.executeRequest(action, this.restServlet_RW, desc.readWriteGraphStore);
                } else {
                    SPARQL_UberServlet.errorMethodNotAllowed(method);
                }
            }
            return;
        }
        if (!this.allowREST_W(action)) {
            SPARQL_UberServlet.errorForbidden("Forbidden: SPARQL Graph Store Protocol : Write operation : " + method);
        }
        this.executeRequest(action, this.restServlet_RW, desc.readWriteGraphStore);
    }

    private void executeRequest(HttpAction action, SPARQL_ServletBase servlet, ServiceRef service) {
        if (service.endpoints.size() == 0) {
            SPARQL_UberServlet.errorMethodNotAllowed(action.request.getMethod());
        }
        servlet.executeLifecycle(action);
    }

    private void executeRequest(HttpAction action, SPARQL_ServletBase servlet) {
        servlet.executeLifecycle(action);
    }

    protected static MediaType contentNegotationQuads(HttpAction action) {
        MediaType mt = ConNeg.chooseContentType(action.request, DEF.quadsOffer, DEF.acceptNQuads);
        if (mt == null) {
            return null;
        }
        if (mt.getContentType() != null) {
            action.response.setContentType(mt.getContentType());
        }
        if (mt.getCharset() != null) {
            action.response.setCharacterEncoding(mt.getCharset());
        }
        return mt;
    }

    private boolean serviceDispatch(HttpAction action, ServiceRef service, String srvName, SPARQL_ServletBase servlet) {
        if (!service.endpoints.contains(srvName)) {
            return false;
        }
        servlet.executeLifecycle(action);
        return true;
    }

    protected String findTrailing(String uri, String dsname) {
        if (dsname.length() >= uri.length()) {
            return "";
        }
        return uri.substring(dsname.length() + 1);
    }

    protected void doHead(HttpServletRequest request, HttpServletResponse response) {
        this.doCommon(request, response);
    }

    protected void doGet(HttpServletRequest request, HttpServletResponse response) {
        this.doCommon(request, response);
    }

    protected void doPost(HttpServletRequest request, HttpServletResponse response) {
        this.doCommon(request, response);
    }

    protected void doOptions(HttpServletRequest request, HttpServletResponse response) {
        this.doCommon(request, response);
    }

    protected void doPut(HttpServletRequest request, HttpServletResponse response) {
        this.doCommon(request, response);
    }

    protected void doDelete(HttpServletRequest request, HttpServletResponse response) {
        this.doCommon(request, response);
    }

    public static class AccessByConfig
    extends SPARQL_UberServlet {
        @Override
        protected boolean allowQuery(HttpAction action) {
            return this.isEnabled(action.dsRef.query);
        }

        @Override
        protected boolean allowUpdate(HttpAction action) {
            return this.isEnabled(action.dsRef.update);
        }

        @Override
        protected boolean allowREST_R(HttpAction action) {
            return this.isEnabled(action.dsRef.readGraphStore) || this.allowREST_W(action);
        }

        @Override
        protected boolean allowREST_W(HttpAction action) {
            return this.isEnabled(action.dsRef.readWriteGraphStore);
        }

        @Override
        protected boolean allowQuadsR(HttpAction action) {
            return this.isEnabled(action.dsRef.readGraphStore);
        }

        @Override
        protected boolean allowQuadsW(HttpAction action) {
            return this.isEnabled(action.dsRef.readWriteGraphStore);
        }

        private boolean isEnabled(ServiceRef service) {
            return service.isActive();
        }
    }

    public static class ReadWrite
    extends SPARQL_UberServlet {
        @Override
        protected boolean allowQuery(HttpAction action) {
            return true;
        }

        @Override
        protected boolean allowUpdate(HttpAction action) {
            return true;
        }

        @Override
        protected boolean allowREST_R(HttpAction action) {
            return true;
        }

        @Override
        protected boolean allowREST_W(HttpAction action) {
            return true;
        }

        @Override
        protected boolean allowQuadsR(HttpAction action) {
            return true;
        }

        @Override
        protected boolean allowQuadsW(HttpAction action) {
            return true;
        }
    }

    public static class ReadOnly
    extends SPARQL_UberServlet {
        @Override
        protected boolean allowQuery(HttpAction action) {
            return true;
        }

        @Override
        protected boolean allowUpdate(HttpAction action) {
            return false;
        }

        @Override
        protected boolean allowREST_R(HttpAction action) {
            return true;
        }

        @Override
        protected boolean allowREST_W(HttpAction action) {
            return false;
        }

        @Override
        protected boolean allowQuadsR(HttpAction action) {
            return true;
        }

        @Override
        protected boolean allowQuadsW(HttpAction action) {
            return false;
        }
    }
}

