/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.fuseki.servlets;

import com.hp.hpl.jena.graph.Graph;
import com.hp.hpl.jena.graph.Node;
import com.hp.hpl.jena.graph.NodeFactory;
import com.hp.hpl.jena.sparql.core.Quad;
import com.hp.hpl.jena.sparql.graph.GraphFactory;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.util.zip.GZIPInputStream;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.fileupload.FileItemIterator;
import org.apache.commons.fileupload.FileItemStream;
import org.apache.commons.fileupload.servlet.ServletFileUpload;
import org.apache.commons.fileupload.util.Streams;
import org.apache.jena.atlas.lib.Pair;
import org.apache.jena.atlas.web.ContentType;
import org.apache.jena.fuseki.FusekiLib;
import org.apache.jena.fuseki.servlets.ActionErrorException;
import org.apache.jena.fuseki.servlets.HttpAction;
import org.apache.jena.fuseki.servlets.SPARQL_REST;
import org.apache.jena.fuseki.servlets.SPARQL_ServletBase;
import org.apache.jena.iri.IRI;
import org.apache.jena.riot.Lang;
import org.apache.jena.riot.RDFLanguages;
import org.apache.jena.riot.lang.StreamRDFCounting;
import org.apache.jena.riot.system.ErrorHandler;
import org.apache.jena.riot.system.ErrorHandlerFactory;
import org.apache.jena.riot.system.IRIResolver;
import org.apache.jena.riot.system.StreamRDF;
import org.apache.jena.riot.system.StreamRDFLib;
import org.slf4j.Logger;

public class SPARQL_Upload
extends SPARQL_ServletBase {
    private static ErrorHandler errorHandler = ErrorHandlerFactory.errorHandlerStd((Logger)log);

    protected void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        this.doCommon(request, response);
    }

    protected void doOptions(HttpServletRequest request, HttpServletResponse response) {
        response.setHeader("Allow", "OPTIONS,POST");
        response.setHeader("Content-Length", "0");
    }

    @Override
    protected void perform(HttpAction action) {
        boolean isMultipart = ServletFileUpload.isMultipartContent((HttpServletRequest)action.request);
        if (!isMultipart) {
            SPARQL_Upload.error(400, "Not a file upload");
        }
        long count = SPARQL_Upload.upload(action, "http://example/upload-base/");
        try {
            action.response.setContentType("text/html");
            action.response.setStatus(200);
            PrintWriter out = action.response.getWriter();
            out.println("<html>");
            out.println("<head>");
            out.println("</head>");
            out.println("<body>");
            out.println("<h1>Success</h1>");
            out.println("<p>");
            out.println("Triples = " + count + "\n");
            out.println("<p>");
            out.println("</p>");
            out.println("<button onclick=\"timeFunction()\">Back to Fuseki</button>");
            out.println("</p>");
            out.println("<script type=\"text/javascript\">");
            out.println("function timeFunction(){");
            out.println("window.location.href = \"/fuseki.html\";}");
            out.println("</script>");
            out.println("</body>");
            out.println("</html>");
            out.flush();
            SPARQL_Upload.success(action);
        }
        catch (Exception ex) {
            SPARQL_Upload.errorOccurred(ex);
        }
    }

    public static long upload(HttpAction action, String base) {
        if (action.isTransactional()) {
            return SPARQL_Upload.uploadTxn(action, base);
        }
        return SPARQL_Upload.uploadNonTxn(action, base);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static long uploadNonTxn(HttpAction action, String base) {
        Pair<String, Graph> p = SPARQL_Upload.uploadWorker(action, base);
        String graphName = (String)p.getLeft();
        Graph graphTmp = (Graph)p.getRight();
        long tripleCount = graphTmp.size();
        log.info(String.format("[%d] Upload: Graph: %s (%d triple(s))", action.id, graphName, tripleCount));
        Node gn = graphName.equals("default") ? Quad.defaultGraphNodeGenerated : NodeFactory.createURI((String)graphName);
        action.beginWrite();
        try {
            FusekiLib.addDataInto(graphTmp, action.getActiveDSG(), gn);
            action.commit();
            long l = tripleCount;
            return l;
        }
        catch (RuntimeException ex) {
            try {
                action.abort();
            }
            catch (Exception ex2) {
                // empty catch block
            }
            SPARQL_Upload.errorOccurred(ex.getMessage());
            long l = -1L;
            return l;
        }
        finally {
            action.endWrite();
        }
    }

    private static long uploadTxn(HttpAction action, String base) {
        return SPARQL_Upload.uploadNonTxn(action, base);
    }

    private static Pair<String, Graph> uploadWorker(HttpAction action, String base) {
        Graph graphTmp = GraphFactory.createDefaultGraph();
        ServletFileUpload upload = new ServletFileUpload();
        String graphName = null;
        long count = -1L;
        String name = null;
        ContentType ct = null;
        Lang lang = null;
        try {
            FileItemIterator iter = upload.getItemIterator(action.request);
            while (iter.hasNext()) {
                String contentTypeHeader;
                FileItemStream item = iter.next();
                String fieldName = item.getFieldName();
                InputStream stream = item.openStream();
                if (item.isFormField()) {
                    String value = Streams.asString((InputStream)stream, (String)"UTF-8");
                    if (fieldName.equals("graph")) {
                        graphName = value;
                        if (graphName == null || graphName.equals("") || graphName.equals("default")) continue;
                        IRI iri = IRIResolver.parseIRI((String)value);
                        if (iri.hasViolation(false)) {
                            SPARQL_Upload.errorBadRequest("Bad IRI: " + graphName);
                        }
                        if (iri.getScheme() == null) {
                            SPARQL_Upload.errorBadRequest("Bad IRI: no IRI scheme name: " + graphName);
                        }
                        if (!iri.getScheme().equalsIgnoreCase("http") && !iri.getScheme().equalsIgnoreCase("https")) continue;
                        if (iri.getRawHost() == null) {
                            SPARQL_Upload.errorBadRequest("Bad IRI: no host name: " + graphName);
                        }
                        if (iri.getRawPath() == null || iri.getRawPath().length() == 0) {
                            SPARQL_Upload.errorBadRequest("Bad IRI: no path: " + graphName);
                        }
                        if (iri.getRawPath().charAt(0) == '/') continue;
                        SPARQL_Upload.errorBadRequest("Bad IRI: Path does not start '/': " + graphName);
                        continue;
                    }
                    if (fieldName.equals("default-graph-uri")) {
                        graphName = null;
                        continue;
                    }
                    log.info(String.format("[%d] Upload: Field=%s ignored", action.id, fieldName));
                    continue;
                }
                name = item.getName();
                if (name == null || name.equals("") || name.equals("UNSET FILE NAME")) {
                    SPARQL_Upload.errorBadRequest("No name for content - can't determine RDF syntax");
                }
                if ((lang = RDFLanguages.contentTypeToLang((String)(ct = ContentType.create((String)(contentTypeHeader = item.getContentType()))).getContentType())) == null) {
                    lang = RDFLanguages.filenameToLang((String)name);
                    if (name.endsWith(".gz")) {
                        stream = new GZIPInputStream(stream);
                    }
                }
                if (lang == null) {
                    lang = RDFLanguages.RDFXML;
                }
                log.info(String.format("[%d] Upload: Filename: %s, Content-Type=%s, Charset=%s => %s", action.id, name, ct.getContentType(), ct.getCharset(), lang.getName()));
                StreamRDF x = StreamRDFLib.graph((Graph)graphTmp);
                StreamRDFCounting dest = StreamRDFLib.count((StreamRDF)x);
                SPARQL_REST.parse(action, (StreamRDF)dest, stream, lang, base);
                count = dest.count();
            }
            if (graphName == null || graphName.equals("")) {
                graphName = "default";
            }
            return Pair.create((Object)graphName, (Object)graphTmp);
        }
        catch (ActionErrorException ex) {
            throw ex;
        }
        catch (Exception ex) {
            SPARQL_Upload.errorOccurred(ex);
            return null;
        }
    }

    @Override
    protected void validate(HttpAction action) {
    }
}

