/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.fuseki.servlets;

import java.io.IOException;
import java.io.PrintWriter;
import java.io.Writer;
import java.util.Map;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.jena.fuseki.servlets.SimpleVelocity;
import org.apache.velocity.VelocityContext;
import org.apache.velocity.app.VelocityEngine;
import org.apache.velocity.runtime.RuntimeServices;
import org.apache.velocity.runtime.log.LogChute;
import org.apache.velocity.runtime.log.NullLogChute;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SimpleVelocityServlet
extends HttpServlet {
    private static Logger vlog = LoggerFactory.getLogger((String)"Velocity");
    private static LogChute velocityLog = new NullLogChute();
    private String docbase;
    private VelocityEngine velocity;
    private String functionsName = null;
    private final Map<String, Object> datamodel;

    public SimpleVelocityServlet(String base, Map<String, Object> datamodel) {
        this.docbase = base;
        this.datamodel = datamodel;
        this.velocity = new VelocityEngine();
        this.velocity.setProperty("runtime.log.logsystem", (Object)velocityLog);
        this.velocity.setProperty("input.encoding", (Object)"UTF-8");
        this.velocity.setProperty("file.resource.loader.path", (Object)base);
        this.velocity.init();
    }

    public void doGet(HttpServletRequest req, HttpServletResponse resp) {
        this.process(req, resp);
    }

    public void doPost(HttpServletRequest req, HttpServletResponse resp) {
        this.process(req, resp);
    }

    private void process(HttpServletRequest req, HttpServletResponse resp) {
        try {
            resp.setContentType("text/html");
            resp.setCharacterEncoding("UTF-8");
            PrintWriter out = resp.getWriter();
            String path = this.path(req);
            VelocityContext vc = SimpleVelocity.createContext(this.datamodel);
            vc.put("request", (Object)req);
            SimpleVelocity.process(this.docbase, path, (Writer)out, vc);
        }
        catch (IOException ex) {
            vlog.warn("IOException", (Throwable)ex);
        }
    }

    private String path(HttpServletRequest request) {
        String path = request.getPathInfo();
        if (path != null) {
            return path;
        }
        path = request.getServletPath();
        if (path != null) {
            return path;
        }
        return null;
    }

    public String getServletInfo() {
        return "Lightweight Velocity Servlet";
    }

    static class SimpleSLF4JLogChute
    implements LogChute {
        private Logger logger;

        SimpleSLF4JLogChute(Logger log) {
            this.logger = log;
        }

        public void init(RuntimeServices rs) throws Exception {
        }

        public void log(int level, String message) {
            if (this.logger == null) {
                return;
            }
            switch (level) {
                case -1: {
                    this.logger.trace(message);
                    return;
                }
                case 0: {
                    this.logger.debug(message);
                    return;
                }
                case 1: {
                    this.logger.info(message);
                    return;
                }
                case 2: {
                    this.logger.warn(message);
                    return;
                }
                case 3: {
                    this.logger.error(message);
                    return;
                }
            }
        }

        public void log(int level, String message, Throwable t) {
            if (this.logger == null) {
                return;
            }
            t = null;
            switch (level) {
                case -1: {
                    this.logger.trace(message, t);
                    return;
                }
                case 0: {
                    this.logger.debug(message, t);
                    return;
                }
                case 1: {
                    this.logger.info(message, t);
                    return;
                }
                case 2: {
                    this.logger.warn(message, t);
                    return;
                }
                case 3: {
                    this.logger.error(message, t);
                    return;
                }
            }
        }

        public boolean isLevelEnabled(int level) {
            switch (level) {
                case -1: {
                    return this.logger.isTraceEnabled();
                }
                case 0: {
                    return this.logger.isDebugEnabled();
                }
                case 1: {
                    return this.logger.isInfoEnabled();
                }
                case 2: {
                    return this.logger.isWarnEnabled();
                }
                case 3: {
                    return this.logger.isErrorEnabled();
                }
            }
            return true;
        }
    }
}

