/*
 * Decompiled with CFR 0.152.
 */
package org.apache.johnzon.mapper.access;

import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.util.HashMap;
import java.util.Map;
import org.apache.johnzon.mapper.MapperException;
import org.apache.johnzon.mapper.access.AccessMode;

public class MethodAccessMode
implements AccessMode {
    @Override
    public Map<String, AccessMode.Reader> findReaders(Class<?> clazz) {
        PropertyDescriptor[] propertyDescriptors;
        HashMap<String, AccessMode.Reader> readers = new HashMap<String, AccessMode.Reader>();
        for (PropertyDescriptor descriptor : propertyDescriptors = this.getPropertyDescriptors(clazz)) {
            Method readMethod = descriptor.getReadMethod();
            if (readMethod == null || readMethod.getDeclaringClass() == Object.class || this.isIgnored(descriptor.getName())) continue;
            readers.put(descriptor.getName(), new MethodReader(readMethod));
        }
        return readers;
    }

    @Override
    public Map<String, AccessMode.Writer> findWriters(Class<?> clazz) {
        PropertyDescriptor[] propertyDescriptors;
        HashMap<String, AccessMode.Writer> writers = new HashMap<String, AccessMode.Writer>();
        for (PropertyDescriptor descriptor : propertyDescriptors = this.getPropertyDescriptors(clazz)) {
            Method writeMethod = descriptor.getWriteMethod();
            if (writeMethod == null || writeMethod.getDeclaringClass() == Object.class || this.isIgnored(descriptor.getName())) continue;
            writers.put(descriptor.getName(), new MethodWriter(writeMethod));
        }
        return writers;
    }

    protected boolean isIgnored(String name) {
        return name.equals("metaClass") || name.contains("$");
    }

    private PropertyDescriptor[] getPropertyDescriptors(Class<?> clazz) {
        PropertyDescriptor[] propertyDescriptors;
        try {
            propertyDescriptors = Introspector.getBeanInfo(clazz).getPropertyDescriptors();
        }
        catch (IntrospectionException e) {
            throw new IllegalStateException(e);
        }
        return propertyDescriptors;
    }

    public static class MethodReader
    extends MethodDecoratedType
    implements AccessMode.Reader {
        public MethodReader(Method method) {
            super(method);
        }

        @Override
        public Type getType() {
            return this.method.getGenericReturnType();
        }

        @Override
        public Object read(Object instance) {
            try {
                return this.method.invoke(instance, new Object[0]);
            }
            catch (Exception e) {
                throw new MapperException(e);
            }
        }
    }

    public static class MethodWriter
    extends MethodDecoratedType
    implements AccessMode.Writer {
        public MethodWriter(Method method) {
            super(method);
        }

        @Override
        public Type getType() {
            return this.method.getGenericParameterTypes()[0];
        }

        @Override
        public void write(Object instance, Object value) {
            try {
                this.method.invoke(instance, value);
            }
            catch (Exception e) {
                throw new MapperException(e);
            }
        }
    }

    public static abstract class MethodDecoratedType
    implements AccessMode.DecoratedType {
        public final Method method;

        public MethodDecoratedType(Method method) {
            this.method = method;
            if (!method.isAccessible()) {
                method.setAccessible(true);
            }
        }

        @Override
        public <T extends Annotation> T getAnnotation(Class<T> clazz) {
            return this.method.getAnnotation(clazz);
        }
    }
}

