/*
 * Decompiled with CFR 0.152.
 */
package org.apache.johnzon.mapper.access;

import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.lang.reflect.Type;
import java.util.HashMap;
import java.util.Map;
import org.apache.johnzon.mapper.JohnzonProperty;
import org.apache.johnzon.mapper.MapperException;
import org.apache.johnzon.mapper.access.AccessMode;

public class FieldAccessMode
implements AccessMode {
    @Override
    public Map<String, AccessMode.Reader> findReaders(Class<?> clazz) {
        HashMap<String, AccessMode.Reader> readers = new HashMap<String, AccessMode.Reader>();
        for (Map.Entry<String, Field> f : this.fields(clazz).entrySet()) {
            String key = f.getKey();
            if (this.isIgnored(key)) continue;
            readers.put(this.extractKey(f.getValue(), key), new FieldReader(f.getValue()));
        }
        return readers;
    }

    @Override
    public Map<String, AccessMode.Writer> findWriters(Class<?> clazz) {
        HashMap<String, AccessMode.Writer> writers = new HashMap<String, AccessMode.Writer>();
        for (Map.Entry<String, Field> f : this.fields(clazz).entrySet()) {
            String key = f.getKey();
            if (this.isIgnored(key)) continue;
            writers.put(this.extractKey(f.getValue(), key), new FieldWriter(f.getValue()));
        }
        return writers;
    }

    private String extractKey(Field f, String key) {
        JohnzonProperty property = f.getAnnotation(JohnzonProperty.class);
        return property != null ? property.value() : key;
    }

    protected boolean isIgnored(String key) {
        return key.contains("$");
    }

    private Map<String, Field> fields(Class<?> clazz) {
        HashMap<String, Field> fields = new HashMap<String, Field>();
        for (Class<?> current = clazz; current != null && current != Object.class; current = current.getSuperclass()) {
            for (Field f : current.getDeclaredFields()) {
                String name = f.getName();
                int modifiers = f.getModifiers();
                if (fields.containsKey(name) || Modifier.isStatic(modifiers) || Modifier.isTransient(modifiers)) continue;
                fields.put(name, f);
            }
        }
        return fields;
    }

    public static class FieldReader
    extends FieldDecoratedType
    implements AccessMode.Reader {
        public FieldReader(Field field) {
            super(field);
        }

        @Override
        public Object read(Object instance) {
            try {
                return this.field.get(instance);
            }
            catch (Exception e) {
                throw new MapperException(e);
            }
        }
    }

    public static class FieldWriter
    extends FieldDecoratedType
    implements AccessMode.Writer {
        public FieldWriter(Field field) {
            super(field);
        }

        @Override
        public void write(Object instance, Object value) {
            try {
                this.field.set(instance, value);
            }
            catch (Exception e) {
                throw new MapperException(e);
            }
        }
    }

    protected static abstract class FieldDecoratedType
    implements AccessMode.DecoratedType {
        protected final Field field;

        public FieldDecoratedType(Field field) {
            this.field = field;
            if (!field.isAccessible()) {
                this.field.setAccessible(true);
            }
        }

        @Override
        public Type getType() {
            return this.field.getGenericType();
        }

        @Override
        public <T extends Annotation> T getAnnotation(Class<T> clazz) {
            return this.field.getAnnotation(clazz);
        }
    }
}

