/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.streams.kstream;

public abstract class Window {
    private long start;
    private long end;

    public Window(long start, long end) {
        this.start = start;
        this.end = end;
    }

    public long start() {
        return this.start;
    }

    public long end() {
        return this.end;
    }

    public boolean overlap(Window other) {
        return this.start() < other.end() || other.start() < this.end();
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Window other = (Window)obj;
        return this.start == other.start && this.end == other.end;
    }

    public int hashCode() {
        long n = this.start << 32 | this.end;
        return (int)(n % 0xFFFFFFFFL);
    }
}

