/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.streams.kstream.internals;

import org.apache.kafka.streams.kstream.Predicate;
import org.apache.kafka.streams.kstream.internals.Change;
import org.apache.kafka.streams.kstream.internals.KTableImpl;
import org.apache.kafka.streams.kstream.internals.KTableProcessorSupplier;
import org.apache.kafka.streams.kstream.internals.KTableValueGetter;
import org.apache.kafka.streams.kstream.internals.KTableValueGetterSupplier;
import org.apache.kafka.streams.processor.AbstractProcessor;
import org.apache.kafka.streams.processor.Processor;
import org.apache.kafka.streams.processor.ProcessorContext;

class KTableFilter<K, V>
implements KTableProcessorSupplier<K, V, V> {
    private final KTableImpl<K, ?, V> parent;
    private final Predicate<K, V> predicate;
    private final boolean filterNot;
    private boolean sendOldValues = false;

    public KTableFilter(KTableImpl<K, ?, V> parent, Predicate<K, V> predicate, boolean filterNot) {
        this.parent = parent;
        this.predicate = predicate;
        this.filterNot = filterNot;
    }

    @Override
    public Processor<K, Change<V>> get() {
        return new KTableFilterProcessor();
    }

    @Override
    public KTableValueGetterSupplier<K, V> view() {
        final KTableValueGetterSupplier<K, V> parentValueGetterSupplier = this.parent.valueGetterSupplier();
        return new KTableValueGetterSupplier<K, V>(){

            @Override
            public KTableValueGetter<K, V> get() {
                return new KTableFilterValueGetter(parentValueGetterSupplier.get());
            }

            @Override
            public String[] storeNames() {
                return parentValueGetterSupplier.storeNames();
            }
        };
    }

    @Override
    public void enableSendingOldValues() {
        this.parent.enableSendingOldValues();
        this.sendOldValues = true;
    }

    private V computeValue(K key, V value) {
        V newValue = null;
        if (value != null && this.filterNot ^ this.predicate.test(key, value)) {
            newValue = value;
        }
        return newValue;
    }

    private class KTableFilterValueGetter
    implements KTableValueGetter<K, V> {
        private final KTableValueGetter<K, V> parentGetter;

        public KTableFilterValueGetter(KTableValueGetter<K, V> parentGetter) {
            this.parentGetter = parentGetter;
        }

        @Override
        public void init(ProcessorContext context) {
            this.parentGetter.init(context);
        }

        @Override
        public V get(K key) {
            return KTableFilter.this.computeValue(key, this.parentGetter.get(key));
        }
    }

    private class KTableFilterProcessor
    extends AbstractProcessor<K, Change<V>> {
        private KTableFilterProcessor() {
        }

        @Override
        public void process(K key, Change<V> change) {
            Object oldValue;
            Object newValue = KTableFilter.this.computeValue(key, change.newValue);
            Object object = oldValue = KTableFilter.this.sendOldValues ? KTableFilter.this.computeValue(key, change.oldValue) : null;
            if (KTableFilter.this.sendOldValues && oldValue == null && newValue == null) {
                return;
            }
            this.context().forward(key, new Change<Object>(newValue, oldValue));
        }
    }
}

