/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.streams.processor.internals;

import java.util.Map;
import java.util.Objects;
import java.util.Properties;
import java.util.Set;

public class InternalTopicConfig {
    private final String name;
    private final Map<String, String> logConfig;
    private Long retentionMs;
    private final Set<CleanupPolicy> cleanupPolicies;

    public InternalTopicConfig(String name, Set<CleanupPolicy> defaultCleanupPolicies, Map<String, String> logConfig) {
        Objects.requireNonNull(name, "name can't be null");
        if (defaultCleanupPolicies.isEmpty()) {
            throw new IllegalArgumentException("Must provide at least one cleanup policy");
        }
        this.name = name;
        this.cleanupPolicies = defaultCleanupPolicies;
        this.logConfig = logConfig;
    }

    boolean isCompacted() {
        return this.cleanupPolicies.contains((Object)CleanupPolicy.compact);
    }

    private boolean isCompactDelete() {
        return this.cleanupPolicies.contains((Object)CleanupPolicy.compact) && this.cleanupPolicies.contains((Object)CleanupPolicy.delete);
    }

    public Properties toProperties(long additionalRetentionMs) {
        Properties result = new Properties();
        for (Map.Entry<String, String> configEntry : this.logConfig.entrySet()) {
            result.put(configEntry.getKey(), configEntry.getValue());
        }
        if (this.retentionMs != null && this.isCompactDelete()) {
            result.put("retention.ms", String.valueOf(this.retentionMs + additionalRetentionMs));
        }
        if (!this.logConfig.containsKey("cleanup.policy")) {
            StringBuilder builder = new StringBuilder();
            for (CleanupPolicy cleanupPolicy : this.cleanupPolicies) {
                builder.append(cleanupPolicy.name()).append(",");
            }
            builder.deleteCharAt(builder.length() - 1);
            result.put("cleanup.policy", builder.toString());
        }
        return result;
    }

    public String name() {
        return this.name;
    }

    public void setRetentionMs(long retentionMs) {
        if (!this.logConfig.containsKey("retention.ms")) {
            this.retentionMs = retentionMs;
        }
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        InternalTopicConfig that = (InternalTopicConfig)o;
        return Objects.equals(this.name, that.name) && Objects.equals(this.logConfig, that.logConfig) && Objects.equals(this.retentionMs, that.retentionMs) && Objects.equals(this.cleanupPolicies, that.cleanupPolicies);
    }

    public int hashCode() {
        return Objects.hash(this.name, this.logConfig, this.retentionMs, this.cleanupPolicies);
    }

    public static enum CleanupPolicy {
        compact,
        delete;

    }
}

