/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.streams.state.internals;

import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import org.apache.kafka.streams.KeyValue;
import org.apache.kafka.streams.errors.InvalidStateStoreException;
import org.apache.kafka.streams.state.KeyValueIterator;
import org.apache.kafka.streams.state.QueryableStoreType;
import org.apache.kafka.streams.state.ReadOnlyKeyValueStore;
import org.apache.kafka.streams.state.internals.StateStoreProvider;

public class CompositeReadOnlyKeyValueStore<K, V>
implements ReadOnlyKeyValueStore<K, V> {
    private final StateStoreProvider storeProvider;
    private final QueryableStoreType<ReadOnlyKeyValueStore<K, V>> storeType;
    private final String storeName;

    public CompositeReadOnlyKeyValueStore(StateStoreProvider storeProvider, QueryableStoreType<ReadOnlyKeyValueStore<K, V>> storeType, String storeName) {
        this.storeProvider = storeProvider;
        this.storeType = storeType;
        this.storeName = storeName;
    }

    @Override
    public V get(K key) {
        List<ReadOnlyKeyValueStore<K, V>> stores = this.storeProvider.stores(this.storeName, this.storeType);
        for (ReadOnlyKeyValueStore<K, V> store : stores) {
            try {
                V result = store.get(key);
                if (result == null) continue;
                return result;
            }
            catch (InvalidStateStoreException e) {
                throw new InvalidStateStoreException("State store is not available anymore and may have been migrated to another instance; please re-discover its location from the state metadata.");
            }
        }
        return null;
    }

    @Override
    public KeyValueIterator<K, V> range(final K from, final K to) {
        NextIteratorFunction nextIteratorFunction = new NextIteratorFunction<K, V>(){

            @Override
            public KeyValueIterator<K, V> apply(ReadOnlyKeyValueStore<K, V> store) {
                try {
                    return store.range(from, to);
                }
                catch (InvalidStateStoreException e) {
                    throw new InvalidStateStoreException("State store is not available anymore and may have been migrated to another instance; please re-discover its location from the state metadata.");
                }
            }
        };
        List<ReadOnlyKeyValueStore<K, V>> stores = this.storeProvider.stores(this.storeName, this.storeType);
        return new CompositeKeyValueIterator(stores.iterator(), nextIteratorFunction);
    }

    @Override
    public KeyValueIterator<K, V> all() {
        NextIteratorFunction nextIteratorFunction = new NextIteratorFunction<K, V>(){

            @Override
            public KeyValueIterator<K, V> apply(ReadOnlyKeyValueStore<K, V> store) {
                try {
                    return store.all();
                }
                catch (InvalidStateStoreException e) {
                    throw new InvalidStateStoreException("State store is not available anymore and may have been migrated to another instance; please re-discover its location from the state metadata.");
                }
            }
        };
        List<ReadOnlyKeyValueStore<K, V>> stores = this.storeProvider.stores(this.storeName, this.storeType);
        return new CompositeKeyValueIterator(stores.iterator(), nextIteratorFunction);
    }

    @Override
    public long approximateNumEntries() {
        List<ReadOnlyKeyValueStore<K, V>> stores = this.storeProvider.stores(this.storeName, this.storeType);
        long total = 0L;
        for (ReadOnlyKeyValueStore<K, V> store : stores) {
            total += store.approximateNumEntries();
        }
        return total < 0L ? Long.MAX_VALUE : total;
    }

    private class CompositeKeyValueIterator
    implements KeyValueIterator<K, V> {
        private final Iterator<ReadOnlyKeyValueStore<K, V>> storeIterator;
        private final NextIteratorFunction<K, V> nextIteratorFunction;
        private KeyValueIterator<K, V> current;

        CompositeKeyValueIterator(Iterator<ReadOnlyKeyValueStore<K, V>> underlying, NextIteratorFunction<K, V> nextIteratorFunction) {
            this.storeIterator = underlying;
            this.nextIteratorFunction = nextIteratorFunction;
        }

        @Override
        public void close() {
            if (this.current != null) {
                this.current.close();
                this.current = null;
            }
        }

        @Override
        public boolean hasNext() {
            while ((this.current == null || !this.current.hasNext()) && this.storeIterator.hasNext()) {
                this.close();
                this.current = this.nextIteratorFunction.apply(this.storeIterator.next());
            }
            return this.current != null && this.current.hasNext();
        }

        @Override
        public KeyValue<K, V> next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            return (KeyValue)this.current.next();
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException("Remove not supported");
        }
    }

    static interface NextIteratorFunction<K, V> {
        public KeyValueIterator<K, V> apply(ReadOnlyKeyValueStore<K, V> var1);
    }
}

