/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.streams.state.internals;

import org.apache.kafka.common.metrics.Sensor;
import org.apache.kafka.common.utils.SystemTime;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.streams.KeyValue;
import org.apache.kafka.streams.StreamsMetrics;
import org.apache.kafka.streams.processor.ProcessorContext;
import org.apache.kafka.streams.processor.StateStore;
import org.apache.kafka.streams.state.WindowStore;
import org.apache.kafka.streams.state.WindowStoreIterator;

public class MeteredWindowStore<K, V>
implements WindowStore<K, V> {
    protected final WindowStore<K, V> inner;
    protected final String metricScope;
    protected final Time time;
    private Sensor putTime;
    private Sensor fetchTime;
    private Sensor flushTime;
    private Sensor restoreTime;
    private StreamsMetrics metrics;

    public MeteredWindowStore(WindowStore<K, V> inner, String metricScope, Time time) {
        this.inner = inner;
        this.metricScope = metricScope;
        this.time = time != null ? time : new SystemTime();
    }

    @Override
    public String name() {
        return this.inner.name();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void init(ProcessorContext context, StateStore root) {
        String name = this.name();
        this.metrics = context.metrics();
        this.putTime = this.metrics.addLatencySensor(this.metricScope, name, "put", new String[0]);
        this.fetchTime = this.metrics.addLatencySensor(this.metricScope, name, "fetch", new String[0]);
        this.flushTime = this.metrics.addLatencySensor(this.metricScope, name, "flush", new String[0]);
        this.restoreTime = this.metrics.addLatencySensor(this.metricScope, name, "restore", new String[0]);
        long startNs = this.time.nanoseconds();
        try {
            this.inner.init(context, root);
        }
        finally {
            this.metrics.recordLatency(this.restoreTime, startNs, this.time.nanoseconds());
        }
    }

    @Override
    public boolean persistent() {
        return this.inner.persistent();
    }

    @Override
    public boolean isOpen() {
        return this.inner.isOpen();
    }

    @Override
    public WindowStoreIterator<V> fetch(K key, long timeFrom, long timeTo) {
        return new MeteredWindowStoreIterator(this.inner.fetch(key, timeFrom, timeTo), this.fetchTime);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void put(K key, V value) {
        long startNs = this.time.nanoseconds();
        try {
            this.inner.put(key, value);
        }
        finally {
            this.metrics.recordLatency(this.putTime, startNs, this.time.nanoseconds());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void put(K key, V value, long timestamp) {
        long startNs = this.time.nanoseconds();
        try {
            this.inner.put(key, value, timestamp);
        }
        finally {
            this.metrics.recordLatency(this.putTime, startNs, this.time.nanoseconds());
        }
    }

    @Override
    public void close() {
        this.inner.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void flush() {
        long startNs = this.time.nanoseconds();
        try {
            this.inner.flush();
        }
        finally {
            this.metrics.recordLatency(this.flushTime, startNs, this.time.nanoseconds());
        }
    }

    WindowStore<K, V> inner() {
        return this.inner;
    }

    private class MeteredWindowStoreIterator<E>
    implements WindowStoreIterator<E> {
        private final WindowStoreIterator<E> iter;
        private final Sensor sensor;
        private final long startNs;

        public MeteredWindowStoreIterator(WindowStoreIterator<E> iter, Sensor sensor) {
            this.iter = iter;
            this.sensor = sensor;
            this.startNs = MeteredWindowStore.this.time.nanoseconds();
        }

        @Override
        public boolean hasNext() {
            return this.iter.hasNext();
        }

        @Override
        public KeyValue<Long, E> next() {
            return (KeyValue)this.iter.next();
        }

        @Override
        public void remove() {
            this.iter.remove();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void close() {
            try {
                this.iter.close();
            }
            finally {
                MeteredWindowStore.this.metrics.recordLatency(this.sensor, this.startNs, MeteredWindowStore.this.time.nanoseconds());
            }
        }
    }
}

