/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.streams.state.internals;

import java.util.Map;
import org.apache.kafka.common.serialization.Serde;
import org.apache.kafka.common.serialization.Serdes;
import org.apache.kafka.common.utils.Bytes;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.streams.processor.StateStore;
import org.apache.kafka.streams.state.internals.AbstractStoreSupplier;
import org.apache.kafka.streams.state.internals.CachingWindowStore;
import org.apache.kafka.streams.state.internals.MeteredWindowStore;
import org.apache.kafka.streams.state.internals.RocksDBWindowStore;

public class RocksDBWindowStoreSupplier<K, V>
extends AbstractStoreSupplier<K, V> {
    private final long retentionPeriod;
    private final boolean retainDuplicates;
    private final int numSegments;
    private final long windowSize;
    private final boolean enableCaching;

    public RocksDBWindowStoreSupplier(String name, long retentionPeriod, int numSegments, boolean retainDuplicates, Serde<K> keySerde, Serde<V> valueSerde, long windowSize, boolean logged, Map<String, String> logConfig, boolean enableCaching) {
        this(name, retentionPeriod, numSegments, retainDuplicates, keySerde, valueSerde, null, windowSize, logged, logConfig, enableCaching);
    }

    public RocksDBWindowStoreSupplier(String name, long retentionPeriod, int numSegments, boolean retainDuplicates, Serde<K> keySerde, Serde<V> valueSerde, Time time, long windowSize, boolean logged, Map<String, String> logConfig, boolean enableCaching) {
        super(name, keySerde, valueSerde, time, logged, logConfig);
        this.retentionPeriod = retentionPeriod;
        this.retainDuplicates = retainDuplicates;
        this.numSegments = numSegments;
        this.windowSize = windowSize;
        this.enableCaching = enableCaching;
    }

    @Override
    public String name() {
        return this.name;
    }

    @Override
    public StateStore get() {
        if (!this.enableCaching) {
            RocksDBWindowStore rocksDbStore = new RocksDBWindowStore(this.name, this.retentionPeriod, this.numSegments, this.retainDuplicates, this.keySerde, this.valueSerde);
            return new MeteredWindowStore(this.logged ? rocksDbStore.enableLogging() : rocksDbStore, "rocksdb-window", this.time);
        }
        RocksDBWindowStore store = new RocksDBWindowStore(this.name, this.retentionPeriod, this.numSegments, false, Serdes.Bytes(), Serdes.ByteArray());
        return new CachingWindowStore(new MeteredWindowStore<Bytes, byte[]>(this.logged ? store.enableLogging() : store, "rocksdb-window", this.time), this.keySerde, this.valueSerde, this.windowSize);
    }

    public long retentionPeriod() {
        return this.retentionPeriod;
    }
}

