/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.streams.processor.internals;

import java.util.Properties;
import org.apache.kafka.clients.producer.MockProducer;
import org.apache.kafka.clients.producer.Producer;
import org.apache.kafka.common.serialization.Serdes;
import org.apache.kafka.common.serialization.Serializer;
import org.apache.kafka.common.utils.Bytes;
import org.apache.kafka.streams.errors.StreamsException;
import org.apache.kafka.streams.processor.ProcessorContext;
import org.apache.kafka.streams.processor.internals.RecordCollector;
import org.apache.kafka.streams.processor.internals.RecordCollectorImpl;
import org.apache.kafka.streams.processor.internals.SinkNode;
import org.apache.kafka.streams.state.StateSerdes;
import org.apache.kafka.test.MockProcessorContext;
import org.junit.Test;

public class SinkNodeTest {
    @Test(expected=StreamsException.class)
    public void invalidInputRecordTimestampTest() {
        Serializer anySerializer = Serdes.Bytes().serializer();
        StateSerdes anyStateSerde = StateSerdes.withBuiltinTypes((String)"anyName", Bytes.class, Bytes.class);
        MockProcessorContext context = new MockProcessorContext(anyStateSerde, (RecordCollector)new RecordCollectorImpl(null, null));
        context.setTime(-1L);
        SinkNode sink = new SinkNode("name", "output-topic", anySerializer, anySerializer, null);
        sink.init((ProcessorContext)context);
        sink.process(null, null);
    }

    @Test(expected=StreamsException.class)
    public void shouldThrowStreamsExceptionOnKeyValyeTypeSerializerMissmatch() {
        Serializer anySerializer = Serdes.Bytes().serializer();
        StateSerdes anyStateSerde = StateSerdes.withBuiltinTypes((String)"anyName", Bytes.class, Bytes.class);
        Properties config = new Properties();
        config.setProperty("bootstrap.servers", "localhost:9092");
        MockProcessorContext context = new MockProcessorContext(anyStateSerde, (RecordCollector)new RecordCollectorImpl((Producer)new MockProducer(true, anySerializer, anySerializer), null));
        context.setTime(0L);
        SinkNode sink = new SinkNode("name", "output-topic", anySerializer, anySerializer, null);
        sink.init((ProcessorContext)context);
        try {
            sink.process((Object)"", (Object)"");
        }
        catch (StreamsException e) {
            if (e.getCause() instanceof ClassCastException) {
                throw e;
            }
            throw new RuntimeException(e);
        }
    }
}

