/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.streams.processor.internals;

import java.util.Arrays;
import java.util.Map;
import java.util.Properties;
import org.apache.kafka.streams.StreamsConfig;
import org.apache.kafka.streams.processor.internals.StreamsKafkaClient;
import org.junit.Assert;
import org.junit.Test;

public class StreamsKafkaClientTest {
    @Test
    public void testConfigFromStreamsConfig() {
        for (String expectedMechanism : Arrays.asList("PLAIN", "SCRAM-SHA-512")) {
            Properties props = new Properties();
            props.setProperty("application.id", "some_app_id");
            props.setProperty("sasl.mechanism", expectedMechanism);
            props.setProperty("bootstrap.servers", "localhost:9000");
            StreamsConfig streamsConfig = new StreamsConfig((Map)props);
            StreamsKafkaClient.Config config = StreamsKafkaClient.Config.fromStreamsConfig((StreamsConfig)streamsConfig);
            Assert.assertEquals((Object)expectedMechanism, config.values().get("sasl.mechanism"));
            Assert.assertEquals((Object)expectedMechanism, (Object)config.getString("sasl.mechanism"));
        }
    }
}

