/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.streams.state.internals;

import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import org.apache.kafka.common.metrics.Metrics;
import org.apache.kafka.common.serialization.Serdes;
import org.apache.kafka.common.serialization.Serializer;
import org.apache.kafka.common.utils.Bytes;
import org.apache.kafka.streams.KeyValue;
import org.apache.kafka.streams.StreamsMetrics;
import org.apache.kafka.streams.processor.ProcessorContext;
import org.apache.kafka.streams.processor.StateStore;
import org.apache.kafka.streams.processor.internals.MockStreamsMetrics;
import org.apache.kafka.streams.state.internals.ChangeLoggingKeyValueBytesStore;
import org.apache.kafka.streams.state.internals.ThreadCache;
import org.apache.kafka.test.InMemoryKeyValueStore;
import org.apache.kafka.test.MockProcessorContext;
import org.apache.kafka.test.NoOpRecordCollector;
import org.apache.kafka.test.TestUtils;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.junit.Before;
import org.junit.Test;

public class ChangeLoggingKeyValueBytesStoreTest {
    private final InMemoryKeyValueStore<Bytes, byte[]> inner = new InMemoryKeyValueStore("kv");
    private final ChangeLoggingKeyValueBytesStore store = new ChangeLoggingKeyValueBytesStore(this.inner);
    private final Map sent = new HashMap();
    private final Bytes hi = Bytes.wrap((byte[])"hi".getBytes());
    private final Bytes hello = Bytes.wrap((byte[])"hello".getBytes());
    private final byte[] there = "there".getBytes();
    private final byte[] world = "world".getBytes();

    @Before
    public void before() {
        NoOpRecordCollector collector = new NoOpRecordCollector(){

            @Override
            public <K, V> void send(String topic, K key, V value, Integer partition, Long timestamp, Serializer<K> keySerializer, Serializer<V> valueSerializer) {
                ChangeLoggingKeyValueBytesStoreTest.this.sent.put(key, value);
            }
        };
        MockProcessorContext context = new MockProcessorContext(TestUtils.tempDirectory(), Serdes.String(), Serdes.Long(), collector, new ThreadCache("testCache", 0L, (StreamsMetrics)new MockStreamsMetrics(new Metrics())));
        context.setTime(0L);
        this.store.init((ProcessorContext)context, (StateStore)this.store);
    }

    @Test
    public void shouldWriteKeyValueBytesToInnerStoreOnPut() throws Exception {
        this.store.put(this.hi, this.there);
        MatcherAssert.assertThat((Object)this.inner.get(this.hi), (Matcher)CoreMatchers.equalTo((Object)this.there));
    }

    @Test
    public void shouldLogChangeOnPut() throws Exception {
        this.store.put(this.hi, this.there);
        MatcherAssert.assertThat((Object)((byte[])this.sent.get(this.hi)), (Matcher)CoreMatchers.equalTo((Object)this.there));
    }

    @Test
    public void shouldWriteAllKeyValueToInnerStoreOnPutAll() throws Exception {
        this.store.putAll(Arrays.asList(KeyValue.pair((Object)this.hi, (Object)this.there), KeyValue.pair((Object)this.hello, (Object)this.world)));
        MatcherAssert.assertThat((Object)this.inner.get(this.hi), (Matcher)CoreMatchers.equalTo((Object)this.there));
        MatcherAssert.assertThat((Object)this.inner.get(this.hello), (Matcher)CoreMatchers.equalTo((Object)this.world));
    }

    @Test
    public void shouldLogChangesOnPutAll() throws Exception {
        this.store.putAll(Arrays.asList(KeyValue.pair((Object)this.hi, (Object)this.there), KeyValue.pair((Object)this.hello, (Object)this.world)));
        MatcherAssert.assertThat((Object)((byte[])this.sent.get(this.hi)), (Matcher)CoreMatchers.equalTo((Object)this.there));
        MatcherAssert.assertThat((Object)((byte[])this.sent.get(this.hello)), (Matcher)CoreMatchers.equalTo((Object)this.world));
    }

    @Test
    public void shouldPutNullOnDelete() throws Exception {
        this.store.put(this.hi, this.there);
        this.store.delete(this.hi);
        MatcherAssert.assertThat((Object)this.inner.get(this.hi), (Matcher)CoreMatchers.nullValue());
    }

    @Test
    public void shouldReturnOldValueOnDelete() throws Exception {
        this.store.put(this.hi, this.there);
        MatcherAssert.assertThat((Object)this.store.delete(this.hi), (Matcher)CoreMatchers.equalTo((Object)this.there));
    }

    @Test
    public void shouldLogKeyNullOnDelete() throws Exception {
        this.store.put(this.hi, this.there);
        this.store.delete(this.hi);
        MatcherAssert.assertThat(this.sent.get(this.hi), (Matcher)CoreMatchers.nullValue());
    }

    @Test
    public void shouldWriteToInnerOnPutIfAbsentNoPreviousValue() throws Exception {
        this.store.putIfAbsent(this.hi, this.there);
        MatcherAssert.assertThat((Object)this.inner.get(this.hi), (Matcher)CoreMatchers.equalTo((Object)this.there));
    }

    @Test
    public void shouldNotWriteToInnerOnPutIfAbsentWhenValueForKeyExists() throws Exception {
        this.store.put(this.hi, this.there);
        this.store.putIfAbsent(this.hi, this.world);
        MatcherAssert.assertThat((Object)this.inner.get(this.hi), (Matcher)CoreMatchers.equalTo((Object)this.there));
    }

    @Test
    public void shouldWriteToChangelogOnPutIfAbsentWhenNoPreviousValue() throws Exception {
        this.store.putIfAbsent(this.hi, this.there);
        MatcherAssert.assertThat((Object)((byte[])this.sent.get(this.hi)), (Matcher)CoreMatchers.equalTo((Object)this.there));
    }

    @Test
    public void shouldNotWriteToChangeLogOnPutIfAbsentWhenValueForKeyExists() throws Exception {
        this.store.put(this.hi, this.there);
        this.store.putIfAbsent(this.hi, this.world);
        MatcherAssert.assertThat((Object)((byte[])this.sent.get(this.hi)), (Matcher)CoreMatchers.equalTo((Object)this.there));
    }

    @Test
    public void shouldReturnCurrentValueOnPutIfAbsent() throws Exception {
        this.store.put(this.hi, this.there);
        MatcherAssert.assertThat((Object)this.store.putIfAbsent(this.hi, this.world), (Matcher)CoreMatchers.equalTo((Object)this.there));
    }

    @Test
    public void shouldReturnNullOnPutIfAbsentWhenNoPreviousValue() throws Exception {
        MatcherAssert.assertThat((Object)this.store.putIfAbsent(this.hi, this.there), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.nullValue()));
    }

    @Test
    public void shouldReturnValueOnGetWhenExists() throws Exception {
        this.store.put(this.hello, this.world);
        MatcherAssert.assertThat((Object)this.store.get(this.hello), (Matcher)CoreMatchers.equalTo((Object)this.world));
    }

    @Test
    public void shouldReturnNullOnGetWhenDoesntExist() throws Exception {
        MatcherAssert.assertThat((Object)this.store.get(this.hello), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.nullValue()));
    }
}

