/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.streams.state.internals;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.kafka.common.metrics.Metrics;
import org.apache.kafka.common.serialization.Serdes;
import org.apache.kafka.streams.KeyValue;
import org.apache.kafka.streams.StreamsMetrics;
import org.apache.kafka.streams.kstream.Window;
import org.apache.kafka.streams.kstream.Windowed;
import org.apache.kafka.streams.kstream.internals.SessionWindow;
import org.apache.kafka.streams.processor.ProcessorContext;
import org.apache.kafka.streams.processor.internals.MockStreamsMetrics;
import org.apache.kafka.streams.state.KeyValueIterator;
import org.apache.kafka.streams.state.SessionStore;
import org.apache.kafka.streams.state.internals.RocksDBSegmentedBytesStore;
import org.apache.kafka.streams.state.internals.RocksDBSessionStore;
import org.apache.kafka.streams.state.internals.SegmentedBytesStore;
import org.apache.kafka.streams.state.internals.SessionKeySchema;
import org.apache.kafka.streams.state.internals.ThreadCache;
import org.apache.kafka.test.MockProcessorContext;
import org.apache.kafka.test.NoOpRecordCollector;
import org.apache.kafka.test.TestUtils;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class RocksDBSessionStoreTest {
    private SessionStore<String, Long> sessionStore;

    @Before
    public void before() {
        RocksDBSegmentedBytesStore bytesStore = new RocksDBSegmentedBytesStore("session-store", 10000L, 3, (SegmentedBytesStore.KeySchema)new SessionKeySchema());
        this.sessionStore = new RocksDBSessionStore((SegmentedBytesStore)bytesStore, Serdes.String(), Serdes.Long());
        MockProcessorContext context = new MockProcessorContext(TestUtils.tempDirectory(), Serdes.String(), Serdes.Long(), new NoOpRecordCollector(), new ThreadCache("testCache", 0L, (StreamsMetrics)new MockStreamsMetrics(new Metrics())));
        this.sessionStore.init((ProcessorContext)context, this.sessionStore);
    }

    @After
    public void close() {
        this.sessionStore.close();
    }

    @Test
    public void shouldPutAndFindSessionsInRange() throws Exception {
        String key = "a";
        Windowed a1 = new Windowed((Object)"a", (Window)new SessionWindow(10L, 10L));
        Windowed a2 = new Windowed((Object)"a", (Window)new SessionWindow(500L, 1000L));
        this.sessionStore.put(a1, (Object)1L);
        this.sessionStore.put(a2, (Object)2L);
        this.sessionStore.put(new Windowed((Object)"a", (Window)new SessionWindow(1500L, 2000L)), (Object)1L);
        this.sessionStore.put(new Windowed((Object)"a", (Window)new SessionWindow(2500L, 3000L)), (Object)2L);
        List<KeyValue> expected = Arrays.asList(KeyValue.pair((Object)a1, (Object)1L), KeyValue.pair((Object)a2, (Object)2L));
        KeyValueIterator values = this.sessionStore.findSessions((Object)"a", 0L, 1000L);
        Assert.assertEquals(expected, RocksDBSessionStoreTest.toList((KeyValueIterator<Windowed<String>, Long>)values));
    }

    @Test
    public void shouldFetchAllSessionsWithSameRecordKey() throws Exception {
        List<KeyValue> expected = Arrays.asList(KeyValue.pair((Object)new Windowed((Object)"a", (Window)new SessionWindow(0L, 0L)), (Object)1L), KeyValue.pair((Object)new Windowed((Object)"a", (Window)new SessionWindow(10L, 10L)), (Object)2L), KeyValue.pair((Object)new Windowed((Object)"a", (Window)new SessionWindow(100L, 100L)), (Object)3L), KeyValue.pair((Object)new Windowed((Object)"a", (Window)new SessionWindow(1000L, 1000L)), (Object)4L));
        for (KeyValue kv : expected) {
            this.sessionStore.put((Windowed)kv.key, kv.value);
        }
        this.sessionStore.put(new Windowed((Object)"aa", (Window)new SessionWindow(0L, 0L)), (Object)5L);
        List<KeyValue<Windowed<String>, Long>> results = RocksDBSessionStoreTest.toList((KeyValueIterator<Windowed<String>, Long>)this.sessionStore.fetch((Object)"a"));
        Assert.assertEquals(expected, results);
    }

    @Test
    public void shouldFindValuesWithinMergingSessionWindowRange() throws Exception {
        String key = "a";
        this.sessionStore.put(new Windowed((Object)"a", (Window)new SessionWindow(0L, 0L)), (Object)1L);
        this.sessionStore.put(new Windowed((Object)"a", (Window)new SessionWindow(1000L, 1000L)), (Object)2L);
        KeyValueIterator results = this.sessionStore.findSessions((Object)"a", -1L, 1000L);
        List<KeyValue> expected = Arrays.asList(KeyValue.pair((Object)new Windowed((Object)"a", (Window)new SessionWindow(0L, 0L)), (Object)1L), KeyValue.pair((Object)new Windowed((Object)"a", (Window)new SessionWindow(1000L, 1000L)), (Object)2L));
        Assert.assertEquals(expected, RocksDBSessionStoreTest.toList((KeyValueIterator<Windowed<String>, Long>)results));
    }

    @Test
    public void shouldRemove() throws Exception {
        this.sessionStore.put(new Windowed((Object)"a", (Window)new SessionWindow(0L, 1000L)), (Object)1L);
        this.sessionStore.put(new Windowed((Object)"a", (Window)new SessionWindow(1500L, 2500L)), (Object)2L);
        this.sessionStore.remove(new Windowed((Object)"a", (Window)new SessionWindow(0L, 1000L)));
        Assert.assertFalse((boolean)this.sessionStore.findSessions((Object)"a", 0L, 1000L).hasNext());
        Assert.assertTrue((boolean)this.sessionStore.findSessions((Object)"a", 1500L, 2500L).hasNext());
    }

    @Test
    public void shouldFindSessionsToMerge() throws Exception {
        Windowed session1 = new Windowed((Object)"a", (Window)new SessionWindow(0L, 100L));
        Windowed session2 = new Windowed((Object)"a", (Window)new SessionWindow(101L, 200L));
        Windowed session3 = new Windowed((Object)"a", (Window)new SessionWindow(201L, 300L));
        Windowed session4 = new Windowed((Object)"a", (Window)new SessionWindow(301L, 400L));
        Windowed session5 = new Windowed((Object)"a", (Window)new SessionWindow(401L, 500L));
        this.sessionStore.put(session1, (Object)1L);
        this.sessionStore.put(session2, (Object)2L);
        this.sessionStore.put(session3, (Object)3L);
        this.sessionStore.put(session4, (Object)4L);
        this.sessionStore.put(session5, (Object)5L);
        KeyValueIterator results = this.sessionStore.findSessions((Object)"a", 150L, 300L);
        Assert.assertEquals((Object)session2, (Object)((KeyValue)results.next()).key);
        Assert.assertEquals((Object)session3, (Object)((KeyValue)results.next()).key);
        Assert.assertFalse((boolean)results.hasNext());
    }

    static List<KeyValue<Windowed<String>, Long>> toList(KeyValueIterator<Windowed<String>, Long> iterator) {
        ArrayList<KeyValue<Windowed<String>, Long>> results = new ArrayList<KeyValue<Windowed<String>, Long>>();
        while (iterator.hasNext()) {
            results.add((KeyValue<Windowed<String>, Long>)iterator.next());
        }
        return results;
    }
}

