/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.streams.state.internals;

import java.util.Arrays;
import java.util.Iterator;
import java.util.NoSuchElementException;
import org.apache.kafka.common.serialization.Serdes;
import org.apache.kafka.common.utils.Bytes;
import org.apache.kafka.streams.KeyValue;
import org.apache.kafka.streams.state.StateSerdes;
import org.apache.kafka.streams.state.internals.DelegatingPeekingKeyValueIterator;
import org.apache.kafka.streams.state.internals.SerializedKeyValueIterator;
import org.apache.kafka.test.KeyValueIteratorStub;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.junit.Assert;
import org.junit.Test;

public class SerializedKeyValueIteratorTest {
    private final StateSerdes<String, String> serdes = new StateSerdes("blah", Serdes.String(), Serdes.String());
    private final Iterator<KeyValue<Bytes, byte[]>> iterator = Arrays.asList(KeyValue.pair((Object)Bytes.wrap((byte[])"hi".getBytes()), (Object)"there".getBytes()), KeyValue.pair((Object)Bytes.wrap((byte[])"hello".getBytes()), (Object)"world".getBytes())).iterator();
    private final DelegatingPeekingKeyValueIterator<Bytes, byte[]> peeking = new DelegatingPeekingKeyValueIterator("store", new KeyValueIteratorStub(this.iterator));
    private final SerializedKeyValueIterator<String, String> serializedKeyValueIterator = new SerializedKeyValueIterator(this.peeking, this.serdes);

    @Test
    public void shouldReturnTrueOnHasNextWhenMoreResults() {
        Assert.assertTrue((boolean)this.serializedKeyValueIterator.hasNext());
    }

    @Test
    public void shouldReturnNextValueWhenItExists() throws Exception {
        MatcherAssert.assertThat((Object)this.serializedKeyValueIterator.next(), (Matcher)CoreMatchers.equalTo((Object)KeyValue.pair((Object)"hi", (Object)"there")));
        MatcherAssert.assertThat((Object)this.serializedKeyValueIterator.next(), (Matcher)CoreMatchers.equalTo((Object)KeyValue.pair((Object)"hello", (Object)"world")));
    }

    @Test
    public void shouldReturnFalseOnHasNextWhenNoMoreResults() throws Exception {
        this.advanceIteratorToEnd();
        Assert.assertFalse((boolean)this.serializedKeyValueIterator.hasNext());
    }

    @Test
    public void shouldThrowNoSuchElementOnNextWhenIteratorExhausted() throws Exception {
        this.advanceIteratorToEnd();
        try {
            this.serializedKeyValueIterator.next();
            Assert.fail((String)"Expected NoSuchElementException on exhausted iterator");
        }
        catch (NoSuchElementException noSuchElementException) {
            // empty catch block
        }
    }

    @Test
    public void shouldPeekNextKey() throws Exception {
        MatcherAssert.assertThat((Object)this.serializedKeyValueIterator.peekNextKey(), (Matcher)CoreMatchers.equalTo((Object)"hi"));
        this.serializedKeyValueIterator.next();
        MatcherAssert.assertThat((Object)this.serializedKeyValueIterator.peekNextKey(), (Matcher)CoreMatchers.equalTo((Object)"hello"));
    }

    @Test(expected=UnsupportedOperationException.class)
    public void shouldThrowUnsupportedOperationOnRemove() throws Exception {
        this.serializedKeyValueIterator.remove();
    }

    private void advanceIteratorToEnd() {
        this.serializedKeyValueIterator.next();
        this.serializedKeyValueIterator.next();
    }
}

