/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.test;

import java.io.File;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.kafka.common.metrics.JmxReporter;
import org.apache.kafka.common.metrics.MetricConfig;
import org.apache.kafka.common.metrics.Metrics;
import org.apache.kafka.common.serialization.Serde;
import org.apache.kafka.common.utils.MockTime;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.streams.KeyValue;
import org.apache.kafka.streams.StreamsMetrics;
import org.apache.kafka.streams.processor.StateRestoreCallback;
import org.apache.kafka.streams.processor.StateStore;
import org.apache.kafka.streams.processor.TaskId;
import org.apache.kafka.streams.processor.internals.InternalProcessorContext;
import org.apache.kafka.streams.processor.internals.MockStreamsMetrics;
import org.apache.kafka.streams.processor.internals.ProcessorNode;
import org.apache.kafka.streams.processor.internals.ProcessorRecordContext;
import org.apache.kafka.streams.processor.internals.RecordCollector;
import org.apache.kafka.streams.processor.internals.RecordContext;
import org.apache.kafka.streams.state.StateSerdes;
import org.apache.kafka.streams.state.internals.ThreadCache;

public class MockProcessorContext
implements InternalProcessorContext,
RecordCollector.Supplier {
    private final Serde<?> keySerde;
    private final Serde<?> valSerde;
    private final RecordCollector.Supplier recordCollectorSupplier;
    private final File stateDir;
    private final MockTime time = new MockTime();
    private MetricConfig config = new MetricConfig();
    private final Metrics metrics;
    private final StreamsMetrics streamsMetrics;
    private final ThreadCache cache;
    private Map<String, StateStore> storeMap = new LinkedHashMap<String, StateStore>();
    private Map<String, StateRestoreCallback> restoreFuncs = new HashMap<String, StateRestoreCallback>();
    long timestamp = -1L;
    private RecordContext recordContext;
    private ProcessorNode currentNode;

    public MockProcessorContext(StateSerdes<?, ?> serdes, RecordCollector collector) {
        this(null, serdes.keySerde(), serdes.valueSerde(), collector, null);
    }

    public MockProcessorContext(File stateDir, Serde<?> keySerde, Serde<?> valSerde, final RecordCollector collector, ThreadCache cache) {
        this(stateDir, keySerde, valSerde, new RecordCollector.Supplier(){

            public RecordCollector recordCollector() {
                return collector;
            }
        }, cache);
    }

    public MockProcessorContext(File stateDir, Serde<?> keySerde, Serde<?> valSerde, RecordCollector.Supplier collectorSupplier, ThreadCache cache) {
        this.stateDir = stateDir;
        this.keySerde = keySerde;
        this.valSerde = valSerde;
        this.recordCollectorSupplier = collectorSupplier;
        this.metrics = new Metrics(this.config, Collections.singletonList(new JmxReporter()), (Time)this.time, true);
        this.cache = cache;
        this.streamsMetrics = new MockStreamsMetrics(this.metrics);
    }

    public RecordCollector recordCollector() {
        RecordCollector recordCollector = this.recordCollectorSupplier.recordCollector();
        if (recordCollector == null) {
            throw new UnsupportedOperationException("No RecordCollector specified");
        }
        return recordCollector;
    }

    public void setTime(long timestamp) {
        if (this.recordContext != null) {
            this.recordContext = new ProcessorRecordContext(timestamp, this.recordContext.offset(), this.recordContext.partition(), this.recordContext.topic());
        }
        this.timestamp = timestamp;
    }

    public Metrics baseMetrics() {
        return this.metrics;
    }

    public TaskId taskId() {
        return new TaskId(0, 0);
    }

    public String applicationId() {
        return "mockApplication";
    }

    public Serde<?> keySerde() {
        return this.keySerde;
    }

    public Serde<?> valueSerde() {
        return this.valSerde;
    }

    public ThreadCache getCache() {
        return this.cache;
    }

    public void initialized() {
    }

    public File stateDir() {
        if (this.stateDir == null) {
            throw new UnsupportedOperationException("State directory not specified");
        }
        return this.stateDir;
    }

    public StreamsMetrics metrics() {
        return this.streamsMetrics;
    }

    public void register(StateStore store, boolean loggingEnabled, StateRestoreCallback func) {
        this.storeMap.put(store.name(), store);
        this.restoreFuncs.put(store.name(), func);
    }

    public StateStore getStateStore(String name) {
        return this.storeMap.get(name);
    }

    public void schedule(long interval) {
        throw new UnsupportedOperationException("schedule() not supported.");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <K, V> void forward(K key, V value) {
        ProcessorNode thisNode = this.currentNode;
        Iterator i$ = thisNode.children().iterator();
        while (i$.hasNext()) {
            ProcessorNode childNode;
            this.currentNode = childNode = (ProcessorNode)i$.next();
            try {
                childNode.process(key, value);
            }
            finally {
                this.currentNode = thisNode;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <K, V> void forward(K key, V value, int childIndex) {
        ProcessorNode childNode;
        ProcessorNode thisNode = this.currentNode;
        this.currentNode = childNode = (ProcessorNode)thisNode.children().get(childIndex);
        try {
            childNode.process(key, value);
        }
        finally {
            this.currentNode = thisNode;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <K, V> void forward(K key, V value, String childName) {
        ProcessorNode thisNode = this.currentNode;
        for (ProcessorNode childNode : thisNode.children()) {
            if (!childNode.name().equals(childName)) continue;
            this.currentNode = childNode;
            try {
                childNode.process(key, value);
                break;
            }
            finally {
                this.currentNode = thisNode;
            }
        }
    }

    public void commit() {
        throw new UnsupportedOperationException("commit() not supported.");
    }

    public String topic() {
        if (this.recordContext == null) {
            return null;
        }
        return this.recordContext.topic();
    }

    public int partition() {
        if (this.recordContext == null) {
            return -1;
        }
        return this.recordContext.partition();
    }

    public long offset() {
        if (this.recordContext == null) {
            return -1L;
        }
        return this.recordContext.offset();
    }

    public long timestamp() {
        if (this.recordContext == null) {
            return this.timestamp;
        }
        return this.recordContext.timestamp();
    }

    public Map<String, Object> appConfigs() {
        return Collections.emptyMap();
    }

    public Map<String, Object> appConfigsWithPrefix(String prefix) {
        return Collections.emptyMap();
    }

    public RecordContext recordContext() {
        return this.recordContext;
    }

    public Map<String, StateStore> allStateStores() {
        return Collections.unmodifiableMap(this.storeMap);
    }

    public void restore(String storeName, List<KeyValue<byte[], byte[]>> changeLog) {
        StateRestoreCallback restoreCallback = this.restoreFuncs.get(storeName);
        for (KeyValue<byte[], byte[]> entry : changeLog) {
            restoreCallback.restore((byte[])entry.key, (byte[])entry.value);
        }
    }

    public void setRecordContext(RecordContext recordContext) {
        this.recordContext = recordContext;
    }

    public void setCurrentNode(ProcessorNode currentNode) {
        this.currentNode = currentNode;
    }

    public ProcessorNode currentNode() {
        return this.currentNode;
    }
}

